<?php
class Moto_Model_Account_Expert extends Moto_Model_Account
{
    public function getReport()
    {
        $allocTable = new Moto_Model_Table_TutorAllocation();
        $contactTable = new Moto_Model_Table_ContactData();
        $userTable = new Moto_Model_Table_Users();
        $formTable = new Moto_Model_Table_RegisterForm();
        $db = $allocTable->getAdapter();
        // Opiekunowie
        $select = $db->select()
            ->from(array('u'=>$userTable->info('name')), array(
                'tutor_id' => 'u.id',
                'first_name' => 'c.first_name',
                'last_name' => 'c.last_name'
            ))
            ->joinLeft(array('c'=>$contactTable->info('name')), 'c.user_id = u.id')
            ->where('u.role = ?', Moto_Model_Account::ROLE_TUTOR)
            ->where('u.active = ?', Moto_Model_Account::STATUS_ACTIVE);
        $tutorsData = $db->fetchAll($select);
        $tutors = array();
        foreach ($tutorsData as $tutor) {
            $tutors[$tutor['tutor_id']] = $tutor;
        }

        // Przypisani uczestnicy
        $select = $db->select()
            ->from(array('a'=>$allocTable->info('name')), array(
                'tutor_id' => 'a.tutor_id',
                'user_id' => 'a.user_id',
                'first_name' => 'f.first_name',
                'last_name' => 'f.last_name'
            ))
            ->joinLeft(array('f'=>$formTable->info('name')), 'f.id = a.form_id')
            ->where('f.status = ?', Moto_Model_Table_RegisterForm::STATUS_ACCEPTED);
        $users = $db->fetchAll($select);
        foreach ($users as $user) {
            $tutors[$user['tutor_id']]['users'][] = $user;
        }
        return $tutors;
    }

    public function getBaseData()
    {
        return array('first_name' => 'Ekspert', 'last_name' => '');
    }
}