<?php
class Moto_Model_Logbook
{
    const TIME_STATUS_BEFORE = 'before';
    const TIME_STATUS_WHILE = 'while';
    const TIME_STATUS_AFTER = 'after';

    private $_userId;

    private $_mainTable;

    private $_mainStore;

    private $_reports = array();

    public function __construct($userId)
    {
        $this->_userId = $userId;
        $this->_mainTable = new Moto_Model_Table_Logbook();
        $this->_loadBase();
    }

    public function getPracticeStatus()
    {
        $formsTable = new Moto_Model_Table_RegisterForm();
        $scheduleTable = new Moto_Model_Table_WorkshopSchedule();
        $db = $formsTable->getAdapter();
        $select = $db->select()
            ->from(array('f'=>$formsTable->info('name')), array(
                'practiceStartDate' => 's.practice_start_date',
                'practiceStopDate' => 's.practice_stop_date'
            ))
            ->joinLeft(array('s'=>$scheduleTable->info('name')), 's.id = f.preferred_date')
            ->where('f.user_id = ?', $this->_userId);
        $row = $db->fetchRow($select);
        $nowStamp = time();
        $practiceStartDate = $row['practiceStartDate'].' 00:00:00';
        $practiceStopDate = $row['practiceStopDate'].' 23:59:59';
        $practiceStartStamp = strtotime($practiceStartDate);
        $practiceStopStamp = strtotime($practiceStopDate);
        if ($nowStamp < $practiceStartStamp) {
            return self::TIME_STATUS_BEFORE;
        }
        if ($nowStamp > $practiceStopStamp) {
            return self::TIME_STATUS_AFTER;
        }
        return self::TIME_STATUS_WHILE;
    }

    public function getPrepareStatus()
    {
        $formsTable = new Moto_Model_Table_RegisterForm();
        $scheduleTable = new Moto_Model_Table_WorkshopSchedule();
        $db = $formsTable->getAdapter();
        $select = $db->select()
            ->from(array('f'=>$formsTable->info('name')), array(
                'prepareStartDate' => 's.prepare_start_date',
                'prepareStopDate' => 's.prepare_stop_date'
            ))
            ->joinLeft(array('s'=>$scheduleTable->info('name')), 's.id = f.preferred_date')
            ->where('f.user_id = ?', $this->_userId);
        $row = $db->fetchRow($select);
        $nowStamp = time();
        $prepareStartDate = $row['prepareStartDate'].' 00:00:00';
        $prepareStopDate = $row['prepareStopDate'].' 23:59:59';
        $prepareStartStamp = strtotime($prepareStartDate);
        $prepareStopStamp = strtotime($prepareStopDate);
        if ($nowStamp < $prepareStartStamp) {
            return self::TIME_STATUS_BEFORE;
        }
        if ($nowStamp > $prepareStopStamp) {
            return self::TIME_STATUS_AFTER;
        }
        return self::TIME_STATUS_WHILE;
    }

    public function hasBaseData()
    {
        if (null === $this->_mainStore) {
            return false;
        }
        return true;
    }

    public function hasCertificateAccess()
    {
        if (null === $this->_mainStore) {
            return false;
        }
        if (1 === (int) $this->_mainStore->certificate_access) {
            return true;
        }
        return false;
    }

    public function getBaseData()
    {
        if (null === $this->_mainStore) {
            return array();
        }
        return $this->_mainStore->toArray();
    }

    public function getTutorInfo()
    {
        $allocTable = new Moto_Model_Table_TutorAllocation();
        $contactTable = new Moto_Model_Table_ContactData();
        $select = $allocTable->select()->where('user_id = ?', $this->_userId);
        $allocRow = $allocTable->fetchRow($select);
        if (null === $allocRow) {
            return null;
        }
        $select = $contactTable->select()->where('user_id = ?', $allocRow->tutor_id);
        $contactRow = $contactTable->fetchRow($select);
        if (null === $contactRow) {
            return null;
        }
        return array(
            'id' => $allocRow->tutor_id,
            'first_name' => $contactRow->first_name,
            'last_name' => $contactRow->last_name
        );
    }

    public function getReports()
    {
        if (empty($this->_reports)) {
            $this->_loadReports();
        }
        return $this->_reports;
    }

    public function getProfession()
    {
        if (null === $this->_mainStore) {
            return null;
        }
        return $this->_mainStore->profession;
    }

    public function setProfession($profession)
    {
        if (null === $this->_mainStore) {
            $this->_createBase();
        }
        $this->_mainStore->profession = $profession;
        return $this;
    }

    public function setPracticePlaceId($id)
    {
        if (null === $this->_mainStore) {
            $this->_createBase();
        }
        $this->_mainStore->practice_place_id = $id;
        return $this;
    }

    public function setUserSummary($summary)
    {
        if (null === $this->_mainStore) {
            $this->_createBase();
        }
        $this->_mainStore->user_summary = $summary;
        return $this;
    }

    public function setTutorSummary($summary)
    {
        if (null === $this->_mainStore) {
            $this->_createBase();
        }
        $this->_mainStore->tutor_summary = $summary;
        return $this;
    }

    public function saveBase()
    {
        if (null === $this->_mainStore) {
            throw new Exception('Próba zapisu podstawowych danych do pustego obiektu');
        }
        $this->_mainStore->save();
    }

    public function setPresentationFilename($filename)
    {
        if (null === $this->_mainStore) {
            return $this;
        }
        $this->_mainStore->presentation_filename = $filename;
        return $this;
    }

    public function setPresentationDate($date)
    {
        if (null === $this->_mainStore) {
            return $this;
        }
        $this->_mainStore->presentation_upload_date = $date;
        return $this;
    }

    public function hasPresentation()
    {
        if (null === $this->_mainStore) {
            return false;
        }
        if (!empty($this->_mainStore->presentation_filename)) {
            return true;
        }
        return false;
    }

    public function getId()
    {
        if (null === $this->_mainStore) {
            throw new Exception('Dziennik nie posiada jeszcze identyfikatora');
        }
        return $this->_mainStore->id;
    }

    public function getUserId()
    {
        return $this->_userId;
    }

    public function getUserInfo()
    {
        $formsTable = new Moto_Model_Table_RegisterForm();
        $userRow = $formsTable->getByUserId($this->_userId);
        if (null === $userRow) {
            throw new Exception('Użytkownik nie dokończył rejestracji');
        }
        return $userRow->toArray();
    }

    public function getFirstDate()
    {
        $reportsTable = new Moto_Model_Table_LogbookReport();
        $select = $reportsTable->select()
            ->where('user_id = ?', $this->_userId)
            ->order('practice_date ASC');
        $row = $reportsTable->fetchRow($select);
        if (null === $row) {
            return null;
        }
        return $row->practice_date;
    }

    public function getLastDate()
    {
        $reportsTable = new Moto_Model_Table_LogbookReport();
        $select = $reportsTable->select()
            ->where('user_id = ?', $this->_userId)
            ->order('practice_date DESC');
        $row = $reportsTable->fetchRow($select);
        if (null === $row) {
            return null;
        }
        return $row->practice_date;
    }

    private function _loadBase()
    {
        $this->_mainStore = $this->_mainTable->getByUserId($this->_userId);
    }

    private function _createBase()
    {
        if (null !== $this->_mainStore) {
            return;
        }
        $this->_mainStore = $this->_mainTable->createRow();
        $this->_mainStore->user_id = $this->_userId;
    }

    private function _loadReports()
    {
        $this->_reports = array();
        $reportsTable = new Moto_Model_Table_LogbookReport();
        $select = $reportsTable->select()
            ->where('user_id = ?', $this->_userId);
        $this->_reports = $reportsTable->fetchAll($select)->toArray();
    }
}