<?php
class Moto_Model_Newsletter_Manager
{
    const STATUS_ACTIVE = 1;

    public static function validateRegisterData($data)
    {
        $status = true;
        $messages = array();
        if (!isset($data['email'])) {
            $status = false;
            $messages['email'] = 'Podaj adres email';
        } else {
            if (!Zend_Validate::is($data['email'], 'EmailAddress')) {
                $status = false;
                $messages['email'] = 'Podaj poprawny adres email';
            } else {
                $table = new Moto_Model_Table_Newsletter();
                if ($table->emailExists($data['email'])) {
                    $status = false;
                    $messages['email'] = 'Podany adres jest już zarejestrowany';
                }
            }
        }
        if (!isset($data['data_agreement']) || 1 != $data['data_agreement']) {
            $status = false;
            $messages['data_agreement'] = 'Pole obowiązkowe';
        }
        return array(
            'status' => $status,
            'messages' => $messages
        );
    }

    public static function register($data)
    {
        $table = new Moto_Model_Table_Newsletter();
        $insertData = array(
            'email' => $data['email'],
            'data_agreement' => $data['data_agreement'],
            'active' => 0,
            'register_date' => date('Y-m-d H:i:s'),
            'token' => $data['token']
        );
        $id = $table->insert($insertData);
        if (0 >= $id) {
            throw new Exception('Błąd zapisu danych');
        }
        $data['templateName'] = 'newsletter-register';
        $data['subject'] = 'Motopraktyki - rejestracja do newslettera';
        Moto_Model_Mailer::sendTo(array('email'=>$data['email']), $data);
        return true;
    }

    public static function activate($token)
    {
        $table = new Moto_Model_Table_Newsletter();
        $row = $table->getByToken($token);
        if (null === $row) {
            throw new Exception('Nieprawidłowy token');
        }
        if (self::STATUS_ACTIVE == $row->active) {
            return array(
                'status' => false,
                'message' => 'Ten adres e-mail został już aktywowany.'
            );
        }
        $row->active = self::STATUS_ACTIVE;
        $row->confirm_date = date('Y-m-d H:i:s');
        $row->save();
        return array(
            'status' => true,
            'message' => 'Twoja rejestracja została potwierdzona.'
        );
    }

    public static function generateToken()
    {
        $table = new Moto_Model_Table_Newsletter();
        $token = sha1('znsjdia'.time());
        $controllCount = 0;
        while ($table->tokenExists($token)) {
            $controllCount++;
            if (1000 < $controllCount) {
                throw new Exception('Błąd generowania tokena');
            }
            $token = sha1('znsjdia'.time());
        }
        return $token;
    }
}