<?php
class Moto_Model_Table_Articles extends Zend_Db_Table
{
    protected $_name = 'articles';
    protected $_primary = array('id');

    public function getPublished()
    {
        $select = $this->select()
            ->where('published = ?', 1)
            ->order('sequence ASC')
            ->order('create_date DESC');
        return $this->fetchAll($select);
    }

    public function getById($id, $published = true)
    {
        $select = $this->select()
            ->where('id = ?', $id);
        if ($published) {
            $select->where('published = ?', 1);
        }
        $row = $this->fetchRow($select);
        if (null === $row) {
            return array();
        }
        return $row->toArray();
    }
}