<?php
class Moto_Model_Table_AttachmentData extends Zend_Db_Table
{
    protected $_name = 'user_poll_attachment_data';
    protected $_primary = array('id');

    public function getUserAnswers($userId, $attachId)
    {
        $select = $this->select()
            ->where('user_id = ?', $userId)
            ->where('attachment_id = ?', $attachId);
        return $this->fetchAll($select)->toArray();
    }

    /**
     * Pobranie odpowiedzi do załącznika o podanym id
     *
     * @param int Identyfikator załącznika
     * @param array Identyfikatory pytań (możliwość ograniczenia zbioru odpowiedzi do podanych pytań)
     */
    public function getAnswersByAttachment($id, $quests = array())
    {
        $select = $this->select()
            ->where('attachment_id = ?', $id);
        if (!empty($quests)) {
            $select->where('question_id IN (?)', $quests);
        }
        return $this->fetchAll($select)->toArray();
    }
}