<?php
class Moto_Model_Table_Chat extends Zend_Db_Table
{
    protected $_name = 'chat';
    protected $_primary = array('id');

    public function getAfterDate($date)
    {
        $select = $this->select()
            ->where('create_date >= ?', $date)
            ->order('create_date ASC');
        return $this->fetchAll($select);
    }

    /**
     * Usunięcie starych wpisów
     */
    public function clearOldData()
    {
        $limitDate = date('Y-m-d H:i:s', (time() - (10 * 60 * 60)));
        $where = $this->getAdapter()->quoteInto('create_date < ?', $limitDate);
        $this->delete($where);
    }
}