<?php
class Moto_Model_Table_Newsletter extends Zend_Db_Table
{
    protected $_name = 'newsletter';
    protected $_primary = array('id');

    public function getByEmail($email)
    {
        $select = $this->select()
            ->where('email = ?', $email);
        return $this->fetchRow($select);
    }

    public function getByToken($token)
    {
        $select = $this->select()->where('token = ?', $token);
        return $this->fetchRow($select);
    }

    public function emailExists($email)
    {
        $select = $this->select()
            ->where('email = ?', $email);
        $item = $this->fetchRow($select);
        if (null === $item) {
            return false;
        }
        return true;
    }

    public function tokenExists($token)
    {
        $select = $this->select()
            ->where('token = ?', $token);
        $item = $this->fetchRow($select);
        if (null === $item) {
            return false;
        }
        return true;
    }
}