<?php
class Moto_Model_Table_RegisterForm extends Zend_Db_Table
{
    const STATUS_NOT_VERIFIED = 'not_verified';
    const STATUS_ACCEPTED = 'accepted';
    const STATUS_REJECTED = 'rejected';

    protected $_name = 'register_forms';
    protected $_primary = array('id');

    public function addForm($data)
    {
        if (!empty($data['phone'])) {
            $data['phone'] = trim(str_replace(array('-', '(', ')'), ' ', $data['phone']));
        }
        if (!empty($data['cell_phone'])) {
            $data['cell_phone'] = trim(str_replace(array('-', '(', ')'), ' ', $data['cell_phone']));
        }
        if (!empty($data['fax'])) {
            $data['fax'] = trim(str_replace(array('-', '(', ')'), ' ', $data['fax']));
        }
        $row = $this->createRow($data);
        $now = date('Y-m-d H:i:s');
        $row->add_date = $now;
        $row->update_date = $now;
        return $row->save();
    }
    
    public function updateForm($data,$id)
    {
        
        if (!empty($data['phone'])) {
            $data['phone'] = trim(str_replace(array('-', '(', ')'), ' ', $data['phone']));
        }
        if (!empty($data['cell_phone'])) {
            $data['cell_phone'] = trim(str_replace(array('-', '(', ')'), ' ', $data['cell_phone']));
        }
        if (!empty($data['fax'])) {
            $data['fax'] = trim(str_replace(array('-', '(', ')'), ' ', $data['fax']));
        }
        
        $where = $this->getAdapter()->quoteInto('user_id = ?', $id);
        return $this->update($data, $where);
        
    }

    public function userIdExists($id)
    {
        $select = $this->select()->where('user_id = ?', $id);
        $row = $this->fetchRow($select);
        if (null === $row) {
            return false;
        }
        return true;
    }

    public function getByUserId($userId)
    {
        $select = $this->select()->where('user_id = ?', $userId);
        return $this->fetchRow($select);
    }

    public function getByStatus($status, $order = array(), $pagination = array())
    {
        $select = $this->select();
        switch ($status) {
            case self::STATUS_ACCEPTED:
                $select->where('status = ?', self::STATUS_ACCEPTED);
                break;
            case self::STATUS_REJECTED:
                $select->where('status = ?', self::STATUS_REJECTED);
                break;
            case self::STATUS_NOT_VERIFIED:
                $select->orWhere('status = ?', self::STATUS_NOT_VERIFIED)
                    ->orWhere('status = ?', '')
                    ->orWhere('status IS NULL');
                break;
            case 'all':
                break;
            default:
                throw new Exception('Nieznany status zgłoszenia');
        }
        if (!empty($pagination)) {
            $select->limitPage($pagination['page'], $pagination['count']);
        }
        if (!empty($order)) {
            $select->order($order);
        }

        $result = $this->fetchAll($select);
        return $result;
    }

    public function getById($id)
    {
        $select = $this->select()->where('id = ?', $id);
        return $this->fetchRow($select);
    }
}