<?php
class Moto_Model_Table_TutorAllocation extends Zend_Db_Table
{
    protected $_name = 'tutor_allocations';
    protected $_primary = array('id');

    public function userExists($userId)
    {
        $select = $this->select()->where('user_id = ?', $userId);
        $result = $this->fetchRow($select);
        if (null === $result) {
            return false;
        }
        return true;
    }

    public function reallocateTutor($userId, $newTutorId)
    {
        $select = $this->select()->where('user_id = ?', $userId);
        $row = $this->fetchRow($select);
        if (null === $row) {
            throw new Exception('Nie znaleziono wpisu dla podanego uczestnika');
        }
        $row->tutor_id = $newTutorId;
        $row->allocation_date = date('Y-m-d H:i:s');
        return $row->save();
    }

    public function asignmentExists($tutorId, $userId)
    {
        $select = $this->select()
            ->where('tutor_id = ?', $tutorId)
            ->where('user_id = ?', $userId);
        $result = $this->fetchRow($select);
        if (null === $result) {
            return false;
        }
        return true;
    }
}