<?php
class Moto_Model_Table_Users extends Zend_Db_Table
{
    protected $_name = 'users';
    protected $_primary = array('id');

    public function emailExists($email)
    {
        $select = $this->select()->where('email = ?', $email);
        $row = $this->fetchRow($select);
        if (null === $row) {
            return false;
        }
        return true;
    }

    public function getByKey($key)
    {
        $select = $this->select()->where('url_hash = ?', $key);
        return $this->fetchRow($select);
    }

    public function getById($id)
    {
        $select = $this->select()->where('id = ?', $id);
        return $this->fetchRow($select);
    }

    public function getByEmail($email)
    {
        $select = $this->select()->where('email = ?', $email);
        return $this->fetchRow($select);
    }

    public function getByRole($role, $limit = null)
    {
        $select = $this->select()->where('role = ?', $role);
        if (null !== $limit) {
            $select->limit($limit);
        }
        return $this->fetchAll($select);
    }

    public function getTutorsByStatus($status, $pagination = array())
    {
        $select = $this->select()
            ->where('role = ?', Moto_Model_Account::ROLE_TUTOR)
            ->where('active = ?', $status);
        if (!empty($pagination)) {
            $select->limitPage($pagination['page'], $pagination['count']);
        }
        return $this->fetchAll($select);
    }

    public function getByRolePaginated($role, $pagination = array())
    {
        $select = $this->select()->where('role = ?', $role);
        if (!empty($pagination)) {
            $select->limitPage($pagination['page'], $pagination['count']);
        }
        $result = $this->fetchAll($select);
        return $result;
    }
}