<?php
class Forum_Model_Manager
{
    const STATUS_ACTIVE = 1;
    const STATUS_REJECTED = 2;

    private $_subjectTab;

    private $_entryTab;

    public function __construct()
    {
        $this->_subjectTab = new Forum_Model_Table_Subject();
        $this->_entryTab = new Forum_Model_Table_Entry();
    }

    public function getSubjects($pagination = null)
    {
        $db = $this->_subjectTab->getAdapter();
        $select = $db->select()
            ->from(array('s' => $this->_subjectTab->info('name')), array(
                'id' => 's.id',
                'content' => 's.content',
                'authorId' => 's.author_id',
                'createDate' => 's.create_date',
                'entryCount' => new Zend_Db_Expr('COUNT(e.id)')
            ))
            ->joinLeft(array('e' => $this->_entryTab->info('name')), "e.subject_id = s.id and e.status = ".self::STATUS_ACTIVE, array())
            ->where('s.status = ?', self::STATUS_ACTIVE)
            ->order('s.create_date DESC')
            ->group('s.id');
        if (!empty($pagination)) {
            $select->limitPage($pagination['page'], $pagination['pp']);
        }
        return $db->fetchAll($select);
    }

    public function addSubject($data, $account)
    {
        $this->_subjectTab->insert(array(
            'author_id' => $account->getId(),
            'content' => $data['content'],
            'create_date' => date('Y-m-d H:i:s'),
            'status' => self::STATUS_ACTIVE
        ));
    }

    public function getSubjectEntries($id, $pagination = null)
    {
        $db = $this->_subjectTab->getAdapter();
        $formTable = new Moto_Model_Table_RegisterForm();
        $contactTable = new Moto_Model_Table_ContactData();
        $select = $db->select()
            ->from(array('e'=>$this->_entryTab->info('name')), array(
                'id' => 'e.id',
                'content' => 'e.content',
                'createDate' => 'e.create_date',
                'authorId' => 'e.author_id',
                'formFirstName' => 'f.first_name',
                'formLastName' => 'f.last_name',
                'contactFirstName' => 'c.first_name',
                'contactLastName' => 'c.last_name'
            ))
            ->joinLeft(array('f'=>$formTable->info('name')), 'f.user_id = e.author_id', array())
            ->joinLeft(array('c'=>$contactTable->info('name')), 'c.user_id = e.author_id', array())
            ->where('e.subject_id = ?', $id)
            ->where('e.status = ?', self::STATUS_ACTIVE)
            ->order('e.create_date ASC');
        if (!empty($pagination)) {
            $select->limitPage($pagination['page'], $pagination['pp']);
        }
        $entries = $db->fetchAll($select);
        return $entries;
    }

    public function getSubject($id, $status = null)
    {
        $select = $this->_subjectTab->select()->where('id = ?', $id);
        if (!empty($status)) {
            $select->where('status = ?', $status);
        }
        $row = $this->_subjectTab->fetchRow($select);
        if (null === $row) {
            return array();
        }
        return $row->toArray();
    }

    public function addEntry($data, $subjectId, $account)
    {
        $this->_entryTab->insert(array(
            'subject_id' => $subjectId,
            'author_id' => $account->getId(),
            'content' => $data['content'],
            'create_date' => date('Y-m-d H:i:s'),
            'status' => self::STATUS_ACTIVE
        ));
    }
}