<?php
class Panel_Bootstrap extends Zend_Application_Module_Bootstrap
{
    protected function _initNavigation()
    {
        $config = new Zend_Config_Xml(APPLICATION_PATH.'/configs/navigation-panel.xml', 'nav');
        $navContainer = new Zend_Navigation($config);
        $app = $this->getApplication();
        $app->bootstrap('view');
        $view = $app->getResource('view');
        $view->assign('navContainer', $navContainer);
        $view->assign('pageLabel', '');
    }

    protected function _initPlugins()
    {
        $app = $this->getApplication();
        $app->bootstrap('frontcontroller');
        $front = $app->getResource('frontcontroller');
        require_once APPLICATION_PATH.'/modules/panel/models/controller/plugin/Auth.php';
        $front->registerPlugin(new Panel_Model_Controller_Plugin_Auth());
    }

    protected function _initRoles()
    {
        $panelConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/panel.ini', APPLICATION_ENV);
        Zend_Registry::set('panel-roles', $panelConfig->panel->roles->toArray());
    }

    protected function _initUser()
    {
        $identity = Zend_Auth::getInstance()->getIdentity();
        if (empty($identity)) {
            return;
        }
        $usersTable = new Moto_Model_Table_Users();
        $user = $usersTable->getByEmail($identity);
        $userData = $user->toArray();
        unset($userData['password_hash']);
        Zend_Registry::set('panel-user', $userData);
        $app = $this->getApplication();
        $app->bootstrap('view');
        $view = $app->getResource('view');
        $view->assign('panelUser', $userData);
    }

    protected function _initAcl()
    {
        $acl = new Zend_Acl();
        $acl->addRole(new Zend_Acl_Role('admin'));
        $acl->addRole(new Zend_Acl_Role('expert'));
        $resources = array(
            'process-app',
            'status-change',
            'cert-access-change',
            'assign-tutor'
        );
        foreach ($resources as $res) {
            $acl->add(new Zend_Acl_Resource($res));
        }
        $acl->allow('admin');
        $acl->allow('expert');

        $expertDeny = array(
            'process-app',
            'status-change',
            'cert-access-change',
            'assign-tutor'
        );
        $acl->deny('expert', $expertDeny);
        Zend_Registry::set('acl', $acl);
    }
}