<?php
class Panel_ExpertController extends Zend_Controller_Action
{
    private $_page;

    private $_pp;

    private $_urlQuery;

    private $_flash;

    private $_facade;

    private $_acl;

    public function init()
    {
        $this->_helper->layout()->setLayout('panel-tutor-list');
        $this->_page = (int) $this->_request->getParam('page', 1);
        $this->_pp = (int) $this->_request->getParam('pp', 9);
        $this->_flash = $this->_helper->getHelper('FlashMessenger');
        $this->_facade = new Panel_Model_Facade();
        $this->view->assign('page', $this->_page);
        $this->view->assign('pp', $this->_pp);
        $this->_acl = Zend_Registry::get('acl');
    }

    public function listBeforeAction()
    {
        $allExperts = $this->_facade->getExpertsByStatus(Moto_Model_Account::STATUS_PENDING);
        $allExpertsCount = count($allExperts);
        // Lista stronicowana
        $paginationData = array(
            'page' => $this->_page,
            'count' => $this->_pp
        );
        $experts = $this->_facade->getExpertsByStatus(Moto_Model_Account::STATUS_PENDING, $paginationData);
        $this->view->assign('experts', $experts);
        $this->view->assign('allCount', $allExpertsCount);
        $this->view->assign('paginator', $this->_getPrevNextPages($allExpertsCount));
        $this->view->assign('backAction', $this->_request->getActionName());
        $this->view->assign('actionUrl', $this->_helper->url->url(array(
            'action' => 'status-change',
            'page' => $this->_page,
            'pp' => $this->_pp
        )));
        $this->view->assign('flashMsgs', $this->_flash->getMessages());
        $this->view->assign('pageLabel', 'Eksperci do weryfikacji');
    }

    public function statusChangeAction()
    {
        if (!$this->_request->isPost()) {
            throw new Zend_Controller_Action_Exception(404);
        }
        $user = Zend_Registry::get('panel-user');
        if (!$this->_acl->isAllowed($user['role'], 'status-change')) {
            $this->_redirect($this->_helper->url->url(array('controller' => 'account', 'action' => 'forbidden', 'id' => null)));
        }
        $backAction = $this->_request->getPost('backAction');
        $backUrl = $this->_helper->url->url(array(
            'action' => $backAction,
            'page' => $this->_page,
            'pp' => $this->_pp
        ));
        $changeType = $this->_request->getPost('changeType');
        $id = (int) $this->_request->getPost('id');
        if (empty($id)) {
            $this->_flash->addMessage('Niepoprawny identyfikator zgłoszenia');
            $this->_redirect($backUrl);
        }
        $usersTable = new Moto_Model_Table_Users();
        $user = $usersTable->getById($id);
        if (null === $user) {
            $this->_flash->addMessage('Niepoprawny identyfikator zgłoszenia');
            $this->_redirect($backUrl);
        }
        switch ($changeType) {
            case 'accept':
                $status = Moto_Model_Account::STATUS_ACTIVE;
                break;
            case 'reject':
                $status = Moto_Model_Account::STATUS_REJECTED;
                break;
            case 'pending':
                $status = Moto_Model_Account::STATUS_PENDING;
                break;
            default:
                $this->_flash->addMessage('Nieznany typ operacji zmiany statusu zgłoszenia eksperta');
                $this->_redirect($backUrl);
        }
        $user->active = $status;
        $ctrl = $user->save();
        // Wysyłka maila do opiekuna, jeśli akceptacja lub odrzucenie zgłoszenia
        if (0 < $ctrl && ('accept' == $changeType || 'reject' == $changeType)) {
            $this->_facade->sendExpertStatusChangeMail($user->email, $changeType);
        }
        $this->_flash->addMessage('Status został zmieniony');
        $this->_redirect($backUrl);
    }

    private function _getPrevNextPages($itemsCount)
    {
        if (1 < $this->_page) {
            $prev = $this->_page - 1;
        } else {
            $prev = 1;
        }
        $lastPageNumber = ceil($itemsCount / $this->_pp);
        if ($lastPageNumber > $this->_page) {
            $next = $this->_page + 1;
        } else {
            $next = $lastPageNumber;
        }
        return array('prev' => $prev, 'next' => $next, 'lastPage' => $lastPageNumber);
    }
}