<?php
class Panel_Model_Facade
{
    public function getTutorsByStatus($status, $pagination = array())
    {
        $usersTable = new Moto_Model_Table_Users();
        $contactTable = new Moto_Model_Table_ContactData();
        $db = $usersTable->getAdapter();
        $select = $db->select()
            ->from(array('u' => $usersTable->info('name')), array(
                'id' => 'u.id',
                'email' => 'u.email',
                'fullRegisterDate' => 'u.full_register_date'
            ))
            ->joinLeft(array('c' => $contactTable->info('name')), 'c.user_id = u.id', array(
                'firstName' => 'c.first_name',
                'lastName' => 'c.last_name',
                'pesel' => 'c.pesel',
                'city' => 'c.city',
                'postalCode' => 'c.postal_code',
                'street' => 'c.street',
                'houseNumber' => 'c.house_number',
                'localNumber' => 'c.local_number',
                'phone' => 'c.phone'
            ))
            ->where('active = ?', $status)
            ->where('role = ?', Moto_Model_Account::ROLE_TUTOR);
        if (!empty($pagination)) {
            $select->limitPage($pagination['page'], $pagination['count']);
        }
        return $db->fetchAll($select);
    }

    public function sendTutorStatusChangeMail($email, $changeType)
    {
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/email/');
        $mail = new Zend_Mail('utf-8');
        switch ($changeType) {
            case 'accept':
                $html = $view->render('tutor-accept-notification.phtml');
                $mail->setSubject('Akceptacja zgłoszenia na opiekuna');
                break;
            case 'reject':
                $html = $view->render('tutor-reject-notification.phtml');
                $mail->setSubject('Odrzucenie zgłoszenia na opiekuna');
                break;
        }
        $mail->addTo($email);
        $mail->setFrom('Motopraktyki.pl@motopraktyki.pl');
        $mail->setBodyHtml($html);
        $mail->send();
    }

    public function sendExpertStatusChangeMail($email, $changeType)
    {
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/email/');
        $mail = new Zend_Mail('utf-8');
        switch ($changeType) {
            case 'accept':
                $html = $view->render('expert-accept-notification.phtml');
                $mail->setSubject('Akceptacja zgłoszenia na eksperta');
                break;
            case 'reject':
                $html = $view->render('expert-reject-notification.phtml');
                $mail->setSubject('Odrzucenie zgłoszenia na eksperta');
                break;
        }
        $mail->addTo($email);
        $mail->setFrom('Motopraktyki.pl@motopraktyki.pl');
        $mail->setBodyHtml($html);
        $mail->send();
    }

    public function getExpertsByStatus($status, $pagination = array())
    {
        $usersTable = new Moto_Model_Table_Users();
        $contactTable = new Moto_Model_Table_ContactData();
        $db = $usersTable->getAdapter();
        $select = $db->select()
            ->from(array('u' => $usersTable->info('name')), array(
                'id' => 'u.id',
                'email' => 'u.email',
                'fullRegisterDate' => 'u.full_register_date'
            ))
            ->joinLeft(array('c' => $contactTable->info('name')), 'c.user_id = u.id', array(
                'firstName' => 'c.first_name',
                'lastName' => 'c.last_name',
                'pesel' => 'c.pesel',
                'city' => 'c.city',
                'postalCode' => 'c.postal_code',
                'street' => 'c.street',
                'houseNumber' => 'c.house_number',
                'localNumber' => 'c.local_number',
                'phone' => 'c.phone'
            ))
            ->where('active = ?', $status)
            ->where('role = ?', Moto_Model_Account::ROLE_EXPERT);
        if (!empty($pagination)) {
            $select->limitPage($pagination['page'], $pagination['count']);
        }
        return $db->fetchAll($select);
    }

    public function getUsersForAllocation($pagination = array())
    {
        $out = array();
        $formsTable = new Moto_Model_Table_RegisterForm();
        $allocsTable = new Moto_Model_Table_TutorAllocation();
        $usersTable = new Moto_Model_Table_Users();
        $contactTable = new Moto_Model_Table_ContactData();
        $scheduleTable = new Moto_Model_Table_WorkshopSchedule();
        $out['allUsers'] = $formsTable->getByStatus(Moto_Model_Table_RegisterForm::STATUS_ACCEPTED)->toArray();
        // Pobranie użytkowników z danej strony z informacją o opiekunie
        $db = $formsTable->getAdapter();
        $select = $db->select()
            ->from(array('f'=>$formsTable->info('name')), array(
                'user_id' => 'f.user_id',
                'form_id' => 'f.id',
                'first_name' => 'f.first_name',
                'last_name' => 'f.last_name',
                'email' => 'f.email',
                'practice_start_date' => 's.practice_start_date'
            ))
            ->joinLeft(array('a'=>$allocsTable->info('name')), 'f.user_id = a.user_id', array(
                'tutor_id' => 'a.tutor_id'
            ))
            ->joinLeft(array('s'=>$scheduleTable->info('name')), 's.id = f.preferred_date')
            ->where('f.status = ?', Moto_Model_Table_RegisterForm::STATUS_ACCEPTED);
        if (!empty($pagination)) {
            $select->limitPage($pagination['page'], $pagination['count']);
        }
        $out['pageUsers'] = $db->fetchAll($select);
        $out['allCount'] = count($out['allUsers']);
        // Lista opiekunów
        $tutorsSelect = $db->select()
            ->from(array('u'=>$usersTable->info('name')), array(
                'tutor_id' => 'u.id',
                'first_name' => 'c.first_name',
                'last_name' => 'c.last_name'
            ))
            ->joinLeft(array('c'=>$contactTable->info('name')), 'c.user_id = u.id')
            ->where('u.role = ?', Moto_Model_Account::ROLE_TUTOR)
            ->where('u.active = ?', Moto_Model_Account::STATUS_ACTIVE);
        $out['allTutors'] = $db->fetchAll($tutorsSelect);
        // Informacje o ilości uczestników przypisanych do opiekunów
        $allocSelect = $db->select()
            ->from(array('a'=>$allocsTable->info('name')), array(
                'tutor_id' => 'a.tutor_id',
                'usersCount' => new Zend_Db_Expr('COUNT(*)')
            ))
            ->group('a.tutor_id');
        $allocInfo = $db->fetchAll($allocSelect);
        $allocInfoFormatted = array();
        foreach ($allocInfo as $allocItem) {
            $allocInfoFormatted[$allocItem['tutor_id']] = $allocItem['usersCount'];
        }
        $out['allocInfo'] = $allocInfoFormatted;

        return $out;
    }

    public function assignTutor($tutorId, $userId, $formId)
    {
        $response = array('status' => true, 'message' => 'Opiekun został przydzielony');
        $allocsTable = new Moto_Model_Table_TutorAllocation();
        $usersTable = new Moto_Model_Table_Users();
        try {
            $user = $usersTable->getById($userId);
            if (null === $user) {
                return array(
                    'status' => false,
                    'message' => 'Nieprawidłowy identyfikator uczestnika praktyk'
                );
            }
            if (Moto_Model_Account::STATUS_ACTIVE != $user->active) {
                return array(
                    'status' => false,
                    'message' => 'Ten uczestnik praktyk ma nieaktywne konto'
                );
            }
            $tutor = $usersTable->getById($tutorId);
            if (null === $tutor) {
                return array(
                    'status' => false,
                    'message' => 'Nieprawidłowy identyfikator opiekuna'
                );
            }
            if (Moto_Model_Account::STATUS_ACTIVE != $tutor->active) {
                return array(
                    'status' => false,
                    'message' => 'Ten opiekun ma nieaktywne konto'
                );
            }
            if ($allocsTable->userExists($userId)) {
                $allocsTable->reallocateTutor($userId, $tutorId);
                return array(
                    'status' => true,
                    'message' => 'Zmieniono opiekuna'
                );
            }
            $allocData = array(
                'tutor_id' => $tutorId,
                'user_id' => $userId,
                'form_id' => $formId,
                'allocation_date' => date('Y-m-d H:i:s')
            );
            $ctrl = $allocsTable->insert($allocData);
            if (0 >= $ctrl) {
                return array(
                    'status' => false,
                    'message' => 'Pojawiły się błędy podczas przydzielania opiekuna'
                );
            }
        } catch (Exception $exc) {
            $response['status'] = false;
            $response['message'] = $exc->getMessage();
        }
        return $response;
    }

    public function removeTutor($userId)
    {
        try {
            $allocsTable = new Moto_Model_Table_TutorAllocation();
            $select = $allocsTable->select()
                ->where('user_id = ?', $userId);
            $row = $allocsTable->fetchRow($select);
            if (null === $row) {
                return array(
                    'status' => false,
                    'message' => 'Nie znaleziono przydziału o podanych parametrach'
                );
            }
            $row->delete();
            return array(
                'status' => true,
                'message' => 'Usunięto opiekuna dla wybranego użytkownika'
            );
        } catch (Exception $exc) {
            return array(
                'status' => false,
                'message' => $exc->getMessage()
            );
        }
    }

    public function getPresenceList($placeId)
    {
        $logTable = new Moto_Model_Table_Logbook();
        $formTable = new Moto_Model_Table_RegisterForm();
        $db = $logTable->getAdapter();
        $select = $db->select()
            ->from(array('b'=>$logTable->info('name')), array(
                'first_name' => 'f.first_name',
                'last_name' => 'f.last_name'
            ))
            ->joinLeft(array('f'=>$formTable->info('name')), 'f.user_id = b.user_id')
            ->where('f.status = ?', Moto_Model_Table_RegisterForm::STATUS_ACCEPTED)
            ->where('b.practice_place_id = ?', $placeId);
        $result = $db->fetchAll($select);
        $motoConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/moto.ini', APPLICATION_ENV);
        $places = $motoConfig->practicePlace->toArray();
        return array(
            'list' => $result,
            'place' => $places[$placeId]
        );
    }

    public function getCertificateList($accessLevel = 'all', $pagination = array())
    {
        $logTable = new Moto_Model_Table_Logbook();
        $formTable = new Moto_Model_Table_RegisterForm();
        $db = $logTable->getAdapter();
        $select = $db->select()
            ->from(array('b'=>$logTable->info('name')), array(
                'logId' => 'b.id',
                'userId' => 'b.user_id',
                'firstName' => 'f.first_name',
                'lastName' => 'f.last_name',
                'email' => 'f.email',
                'city' => 'f.registered_place',
                'presentationUploadDate' => 'b.presentation_upload_date',
                'certificateAccess' => 'b.certificate_access'
            ))
            ->joinLeft(array('f'=>$formTable->info('name')), 'f.user_id = b.user_id')
            ->where('f.status = ?', Moto_Model_Table_RegisterForm::STATUS_ACCEPTED);
        if ('all' != $accessLevel) {
            $select->where('b.certificate_access = ?', $accessLevel);
        }
        if (!empty($pagination)) {
            $select->limitPage($pagination['page'], $pagination['count']);
        }
        return $db->fetchAll($select);
    }

    public function changeCertificateAccess($data)
    {
        $logTable = new Moto_Model_Table_Logbook();
        $select = $logTable->select()->where('id = ?', $data['logId']);
        $log = $logTable->fetchRow($select);
        if (null === $log) {
            throw new Exception('Nieprawidłowy identyfikator dziennika');
        }
        $log->certificate_access = $data['cert'];
        $ctrl = $log->save();
        if (0 < $data['cert'] && 0 < $ctrl) {
            $logData = $log->toArray();
            $usersTable = new Moto_Model_Table_Users();
            $user = $usersTable->getById($logData['user_id']);
            $userData = $user->toArray();
            try {
                Moto_Model_Mailer::sendTo($userData, array(
                    'templateName'=>'certificate-accept',
                    'subject' => 'Zaświadczenie i certyfikat'
                ));
            } catch (Exception $e) {}
        }
        $response = array();
        if (0 < $ctrl) {
            $response['status'] = true;
            $response['message'] = (0 < $data['cert']) ? 'Certyfikat został udostępniony' : 'Certyfikat został zablokowany';
        } else {
            $response['status'] = false;
            $response['message'] = 'Wystąpiły błędy podczas zmiany dostępu do certyfikatu';
        }
        return $response;
    }

    public function getBills()
    {
        $logTable = new Moto_Model_Table_Logbook();
        $db = $logTable->getAdapter();
        $select = $db->select()
            ->from(array('b'=>$logTable->info('name')), array(
                'userCount' => new Zend_Db_Expr('COUNT(b.user_id)'),
                'placeId' => 'b.practice_place_id'
            ))
            ->where('certificate_access = ?', 1)
            ->group('practice_place_id');
        $result = $db->fetchAll($select);
        $out = array();
        foreach ($result as $value) {
            $out[$value['placeId']] = $value['userCount'];
        }
        return $out;
    }

    public function getTutorBills()
    {
        $userTable = new Moto_Model_Table_Users();
        $contactTable = new Moto_Model_Table_ContactData();
        $allocsTable = new Moto_Model_Table_TutorAllocation();
        $logTable = new Moto_Model_Table_Logbook();
        $db = $userTable->getAdapter();
        
        $select = $db->select()
            ->from(array('u'=>$userTable->info('name')), array(
                'userId' => 'u.id',
                'role' => 'u.role',
                'firstName' => 'c.first_name',
                'lastName' => 'c.last_name',
                'email' => 'u.email',
                'phone' => 'c.phone',
            ))
            ->joinLeft(array('c'=>$contactTable->info('name')), 'c.user_id = u.id', array())
            ->where('u.role = ?', Moto_Model_Account::ROLE_TUTOR)
            ->where('u.active = ?', Moto_Model_Account::STATUS_ACTIVE);
        $tutorsResult = $db->fetchAll($select);
        $tutors = array();
        foreach ($tutorsResult as $value) {
            $tutors[$value['userId']] = $value;
            $tutors[$value['userId']]['userCount'] = 0;
        }

        $select = $db->select()
            ->from(array('u'=>$userTable->info('name')), array(
                'tutorId' => 'u.id',
                'role' => 'u.role',
                'userCount' => new Zend_Db_Expr('COUNT(a.user_id)')
            ))
            ->joinLeft(array('a'=>$allocsTable->info('name')), 'a.tutor_id = u.id', array())
            ->joinLeft(array('b'=>$logTable->info('name')), 'b.user_id = a.user_id', array())
            ->where('u.role = ?', Moto_Model_Account::ROLE_TUTOR)
            ->where('u.active = ?', Moto_Model_Account::STATUS_ACTIVE)
            ->where('b.certificate_access = ?', 1)
            ->group('u.id');
        $result = $db->fetchAll($select);
        foreach ($result as $value) {
            $tutors[$value['tutorId']]['userCount'] = $value['userCount'];
        }

        return $tutors;
    }
}