$(document).ready(function() {
    var birthDate = $('#birthDate');
    var formDate = $('#formDate');
    var billDepartureDate = $('#departureDate');

    birthDate.datepicker({
        altFormat: 'yy-mm-dd',
        dateFormat: 'yy-mm-dd',
        changeYear: true,
        yearRange: '1900:2014'
    });
    formDate.datepicker({
        altFormat: 'yy-mm-dd',
        dateFormat: 'yy-mm-dd',
        changeYear: true,
        yearRange: '2000:2014'
    });
    billDepartureDate.datepicker({
        altFormat: 'yy-mm-dd',
        dateFormat: 'yy-mm-dd',
        changeYear: true,
        yearRange: '2010:2014'
    });

    birthDate.live('change', function() {
        var bDate = birthDate.val();
        if ('' == bDate) {
            return;
        };
        var bDateParts = bDate.split('-');
        var bYear = parseInt(bDateParts[0]);
        var nowDate = new Date();
        var nowYear = nowDate.getFullYear();
        var age = nowYear - bYear;
        $('#age').val(age);
    });
})