/**
* @projectDescription   various eye candy for Motopraktyki pages. 2013-01-09, SDOC 2.0
*
* @author   Karol Klat akarso@femur.pl
* @version  1.0
*/


/**
* Create a new instance of MotopraktykiPages.
*
* @classDescription   This is the main class
* @return {init}   Revealing module pattern, exposes init function only
* @type {Function}
* @constructor 
*/
var MotopraktykiPages = function ($) {
	"use strict";
    var counter = 0,
	commentsHeight, //height of div with comments (lessons and sos giovanni pages)
	ajaxSuccess,
	ajaxCall,
	bindEvents,
	validateForms,
	onPageLoad,
	setFiller,
	resizeBody,
	changeInputType,
	ajaxCalled = false;
	
	
	/**
	* ajax callback
	* @param {Object} response    ajax response
	* @return {undefined}   Returns undefined
	*/
    ajaxSuccess = function (response) {};

    
	/**
	* executes ajax calls, if applicable
	* @return {undefined}   Returns undefined
	*/
    ajaxCall = function (url) {
        $.ajax({
            type: "POST",
			dataType: 'html',
            url: url,
            data:"{}",
            success: ajaxSuccess,
            error: function () {}
        });
    };

    
	/**
	* binds various events
	* @return {undefined}   Returns undefined
	*/
    bindEvents = function () {		
		//$('.link_login, .login_widget h5').click(toggleLoginWidget);
    };

    
	/**
	* validates forms, if applicable
	* @return {boolean}   Returns true on success, false otherwise
	*/
    validateForms = function () {
      $('#form_id').validate({
          //code for validation
      });
    };

    
	/**
	* page load callback, lot of stuff here
	* @return {undefined}   Returns undefined
	*/
    onPageLoad = function () {
	
		$("ul li:last-child").addClass("last");
		$("ul li:first-child").addClass("first");
        bindEvents();
    };
	
	
	
	/**
	* sets height of the filler div, if such a div exists
	* @return {undefined}   Returns undefined
	*/
    setFiller = function () {
		$('.filler').css({
	   'position' : 'absolute',
	   'bottom' : '0',
	   'height' : $('.wrapper').height() - 707 - 62 //.wrapper bg position + footer total height (FIXME)
	 });
	};
	
	
	/**
	* resizes body depending on viewport height 
	* @return {undefined}   Returns undefined
	*/
	resizeBody = function () {
		var windowHeight = $(window).height(),
		wrapperHeight = $(".wrapper").height(),
		diff = parseInt($('.ribbons').css('padding-top'), 10) + $('footer img').height() - $('footer').height();
		console.info('windowHeight: ' + windowHeight + ' wrapperHeight: ' + wrapperHeight + ' diff: ' + diff);
		//console.info('(windowHeight - diff): ' + (windowHeight - diff) + ' wrapperHeight: ' + wrapperHeight + ' paddingBottom: ' + (wrapperHeight - (windowHeight - diff)));
		if ((windowHeight - diff) < wrapperHeight) {
			//if(wrapperHeight - (windowHeight - diff) < 100) {
				//$("body").css("padding-bottom", wrapperHeight - (windowHeight - diff)); 
				$("body").css("padding-bottom", 60); //FIXME: recalculate
			//}
		} else {
			$("body").css("padding-bottom", 20);
		}
	};
	

    return{
        init : onPageLoad
    };  

}

 

$(document).ready(function () {
    var page = new MotopraktykiPages(jQuery);
    page.init();
});


String.prototype.trim = function() {
	return this.replace(/^\s+|\s+$/g, '');
};




//(function ($) {
//	//namespace
//}(jQuery));
