<?php
class BillController extends Moto_Model_Account_Controller
{
    private $_flash;

    public function init()
    {
        if (null === $this->_account) {
            $this->_redirect($this->_helper->url->url(array('controller'=>'auth', 'action'=>'login')));
        }
        $this->_flash = $this->_helper->getHelper('FlashMessenger');
    }

    public function indexAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $config = new Zend_Config_Ini(APPLICATION_PATH.'/configs/moto.ini', APPLICATION_ENV);
        $bill = new Moto_Model_Transit_Bill($this->_account->getId(), $config->toArray());
        $positions = $bill->getPositions();
        $this->view->assign('carPositions', $positions[Moto_Model_Transit_Bill::BILL_TYPE_CAR]);
        $this->view->assign('publicPositions', $positions[Moto_Model_Transit_Bill::BILL_TYPE_PUBLIC]);
        $this->view->assign('billValue', $bill->getValue());
        $this->view->assign('targets', $config->departureTarget->toArray());
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        $this->view->assign('flashMsgs', $this->_flash->getMessages());
        if ($this->_request->isPost()) {
            $formData = $this->_request->getPost('form');
            $billInput = new Moto_Model_Transit_BillInput($formData);
            $dataInfo = $billInput->validate();
            $filtered = $billInput->getFiltered();
            if (!$dataInfo['status']) {
                $this->view->assign('data', $filtered);
                $this->view->assign('msgs', $dataInfo['messages']);
                return;
            }
            $filtered['user_id'] = $this->_account->getId();
            $billTable = new Moto_Model_Table_JourneyBill();
            $id = $billTable->addPosition($filtered);
            if (0 < $id) {
                $this->_flash->addMessage('Pozycja rozliczenia została zapisana');
            } else {
                $this->_flash->addMessage('Wystąpiły błędy podczas zapisu danych');
            }
            $this->_redirect($this->_helper->url->url(array()));
        }
    }

    public function pdfAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $this->_response->setHeader('Content-type', 'application/pdf');

        $type = trim(strip_tags($this->_request->getParam('type')));
        $config = new Zend_Config_Ini(APPLICATION_PATH.'/configs/moto.ini', APPLICATION_ENV);
        $bill = new Moto_Model_Transit_Bill($this->_account->getId(), $config->toArray());
        $positions = $bill->getPositions();
        $formTable = new Moto_Model_Table_RegisterForm();
        $userDataRow = $formTable->getByUserId($this->_account->getId());
        if (empty($userDataRow)) {
            throw new Zend_Controller_Action_Exception(404);
        }

        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/bill/');
        $view->assign('domain', 'http://'.$this->_request->getServer('HTTP_HOST'));
        $view->assign('userData', $userDataRow->toArray());
        $view->assign('targets', $config->departureTarget->toArray());
        $view->assign('billValue', $bill->getValue());
        if (Moto_Model_Transit_Bill::BILL_TYPE_CAR == $type) {
            $view->assign('data', $positions[Moto_Model_Transit_Bill::BILL_TYPE_CAR]);
            $html = $view->render('car.phtml');
        }
        if (Moto_Model_Transit_Bill::BILL_TYPE_PUBLIC == $type) {
            $view->assign('data', $positions[Moto_Model_Transit_Bill::BILL_TYPE_PUBLIC]);
            $html = $view->render('public.phtml');
        }
        require_once("dompdf/dompdf_config.inc.php");
        $dompdf = new DOMPDF();
        $dompdf->load_html($html, 'utf-8');
        $dompdf->render();
        echo $dompdf->output();
    }
}