<?php
class ChatController extends Moto_Model_Account_Controller
{
    public function init()
    {
        if (null === $this->_account) {
            $this->_redirect($this->_helper->url->url(array('controller'=>'auth', 'action'=>'login')));
        }
    }

    /**
     * Ekran chat-u
     */
    public function indexAction()
    {
        $chatTable = new Moto_Model_Table_Chat();
        $chatTable->clearOldData();
        $this->view->assign('initDate', date('Y-m-d H:i:s'));
    }

    /**
     * Akcja ajax-owa dodania wpisu
     */
    public function addAction()
    {
        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $this->_response->setHeader('Content-type', 'application/json');
        if (!$this->_request->isPost()) {
            throw new Zend_Controller_Action_Exception(404);
        }
        $content = strip_tags(trim($this->_request->getPost('content')));
        if (empty($content)) {
            return json_encode(array('status'=>false));
        }
        if (500 < mb_strlen($content, 'utf-8')) {
            $content = mb_substr($content, 0, 500);
        }
        try {
            $chatTable = new Moto_Model_Table_Chat();
            $userData = $this->_account->getBaseData();
            $chatData = array(
                'user_id' => $this->_account->getId(),
                'user_name' => $userData['first_name'].' '.$userData['last_name'],
                'create_date' => date('Y-m-d H:i:s'),
                'content' => $content
            );
            $chatTable->insert($chatData);
        } catch (Exception $exc) {
            return json_encode(array('status'=>false));
        }
        echo json_encode(array('status'=>true));
    }

    /**
     * Akcja ajax-owa pobrania wpisów
     */
    public function contentAction()
    {
        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/chat/');
        try {
            $initDate = trim(strip_tags($this->_request->getParam('initDate')));
            $chatTable = new Moto_Model_Table_Chat();
            $rows = $chatTable->getAfterDate($initDate)->toArray();
            $view->assign('rows', $rows);
        } catch (Exception $exc) {
            echo null;
            return;
        }
        echo $view->render('content.phtml');
    }
}