<?php

class NewsletterController extends Zend_Controller_Action
{
    private $_account;

    private $_flash;

    public function init()
    {
        $this->_account = Moto_Model_Account_Factory::getByAuth();
        $this->_flash = $this->_helper->getHelper('FlashMessenger');
    }

    // Formularz zapisu do newslettera
    public function indexAction()
    {
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        $this->view->assign('flashMsgs', $this->_flash->getMessages());
        if ($this->_request->isPost()) {
            $formData = $this->_request->getPost('form');
            $filtered = array();
            foreach ($formData as $key => $value) {
                $filtered[$key] = trim(strip_tags($value));
            }
            $info = Moto_Model_Newsletter_Manager::validateRegisterData($filtered);
            if (!$info['status']) {
                $this->view->assign('data', $filtered);
                $this->view->assign('messages', $info['messages']);
                return;
            }
            try {
                $db = $this->getInvokeArg('bootstrap')->getResource('db');
                $db->beginTransaction();
                $filtered['domain'] = 'http://'.$this->_request->getServer('HTTP_HOST');
                $filtered['token'] = Moto_Model_Newsletter_Manager::generateToken();
                $filtered['activateUrl'] = $filtered['domain'].$this->_helper->url->url(array(
                    'action' => 'activate',
                    'token' => $filtered['token']
                ));
                $regInfo = Moto_Model_Newsletter_Manager::register($filtered);
                $db->commit();
            } catch (Exception $exc) {
                $db->rollBack();
                $this->_flash->addMessage('Wystąpiły błędy podczas zapisu danych. Spróbuj ponownie.');
                $this->_redirect($this->_helper->url->url(array()));
            }
            if (!$regInfo) {
                $this->_flash->addMessage('Wystąpiły błędy podczas zapisu danych. Spróbuj ponownie.');
                $this->_redirect($this->_helper->url->url(array()));
            }
            $this->_flash->addMessage('Dane zostały zapisane.');
            $this->_redirect($this->_helper->url->url(array('action'=>'summary')));
        }
    }

    public function activateAction()
    {
        try {
            $token = trim(strip_tags($this->_request->getParam('token')));
            $info = Moto_Model_Newsletter_Manager::activate($token);
            $this->view->assign('message', $info['message']);
        } catch (Exception $exc) {
            $this->view->assign('error', 1);
        }
    }

    public function summaryAction()
    {
        $flashMsg = $this->_flash->getMessages();
        if (empty($flashMsg)) {
            $this->_redirect($this->_helper->url->url(array('action'=>'index')));
        }
    }
}