<?php
class PollController extends Moto_Model_Account_Controller
{
    private $_flash;

    public function init()
    {
        if (null === $this->_account) {
            $this->_redirect($this->_helper->url->url(array('controller'=>'auth', 'action'=>'login')));
        }
        $this->_flash = $this->_helper->getHelper('FlashMessenger');
    }

    public function practiceBeforeAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        // Ankietę można wypełnić tylko raz
        if (Moto_Model_Poll_Manager::hasUserCompleted($this->_account->getId(), Moto_Model_Poll_Manager::ID_PRACTICE_BEFORE)) {
            $this->_redirect($this->_helper->url->url(array('action' => 'practice-before-pdf')));
        }
        $poll = Moto_Model_Poll_Manager::getById(Moto_Model_Poll_Manager::ID_PRACTICE_BEFORE);
        $this->view->assign('poll', $poll->toArray());
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        // Zapis ankiety
        if ($this->_request->isPost()) {
            $postData = $this->_request->getPost('form');
            $filtered = array();
            foreach ($postData as $key => $value) {
                $tmp = array();
                if (isset($value['answer'])) {
                    $tmp['answer'] = trim(strip_tags($value['answer']));
                }
                if (isset($value['comment'])) {
                    $tmp['comment'] = trim(strip_tags($value['comment']));
                }
                $filtered[$key] = $tmp;
            }
            $info = $poll->validateData($filtered);
            if (!$info['status']) {
                $this->view->assign('data', $filtered);
                $this->view->assign('msgs', $info['messages']);
                return;
            }
            $db = $this->getInvokeArg('bootstrap')->getResource('db');
            try {
                $db->beginTransaction();
                $info = $poll->saveAnswers($filtered, $this->_account->getId());
                $db->commit();
            } catch (Exception $exc) {
                $db->rollBack();
                $this->_flash->addMessage('Wystąpiły błędy podczas zapisu ankiety');
                $this->_redirect($this->_helper->url->url(array()));
            }
            $this->_flash->addMessage('Ankieta została pomyślnie zapisana');
            $this->_redirect($this->_helper->url->url(array('action'=>'summary')));
        }
    }

    public function prepareBeforeAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        // Ankietę można wypełnić tylko raz
        if (Moto_Model_Poll_Manager::hasUserCompleted($this->_account->getId(), Moto_Model_Poll_Manager::ID_PREPARE_BEFORE)) {
            $this->_redirect($this->_helper->url->url(array('action' => 'prepare-before-pdf')));
        }
        $poll = Moto_Model_Poll_Manager::getById(Moto_Model_Poll_Manager::ID_PREPARE_BEFORE);
        $this->view->assign('poll', $poll->toArray());
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        // Zapis ankiety
        if ($this->_request->isPost()) {
            $postData = $this->_request->getPost('form');
            $filtered = array();
            foreach ($postData as $key => $value) {
                $tmp = array();
                if (isset($value['answer'])) {
                    $tmp['answer'] = trim(strip_tags($value['answer']));
                }
                if (isset($value['comment'])) {
                    $tmp['comment'] = trim(strip_tags($value['comment']));
                }
                $filtered[$key] = $tmp;
            }
            $info = $poll->validateData($filtered);
            if (!$info['status']) {
                $this->view->assign('data', $filtered);
                $this->view->assign('msgs', $info['messages']);
                return;
            }
            $db = $this->getInvokeArg('bootstrap')->getResource('db');
            try {
                $db->beginTransaction();
                $info = $poll->saveAnswers($filtered, $this->_account->getId());
                $db->commit();
            } catch (Exception $exc) {
                $db->rollBack();
                $this->_flash->addMessage('Wystąpiły błędy podczas zapisu ankiety');
                $this->_redirect($this->_helper->url->url(array()));
            }
            $this->_flash->addMessage('Ankieta została pomyślnie zapisana');
            $this->_redirect($this->_helper->url->url(array('action'=>'summary')));
        }
    }

    public function practiceAfterAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $logbook = new Moto_Model_Logbook($this->_account->getId());
        // Uczestnik nie zakończył praktyk
        if (Moto_Model_Logbook::TIME_STATUS_AFTER != $logbook->getPracticeStatus()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        // Ankietę można wypełnić tylko raz
        if (Moto_Model_Poll_Manager::hasUserCompleted($this->_account->getId(), Moto_Model_Poll_Manager::ID_PRACTICE_AFTER)) {
            $this->_redirect($this->_helper->url->url(array('action' => 'practice-after-pdf')));
        }
        $poll = Moto_Model_Poll_Manager::getById(Moto_Model_Poll_Manager::ID_PRACTICE_AFTER);
        $profession = $logbook->getProfession();
        $motoConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/moto.ini', APPLICATION_ENV);
        $attachmentId = $motoConfig->pollAttachment->{$profession}->id;
        if (null === $attachmentId) {
            $this->_flash->addMessage('Nieprawidłowy plik załącznika do ankiety');
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'regular'
            )));
        }
        $attachment = Moto_Model_Poll_Manager::getAttachmentById($attachmentId);
        $this->view->assign('poll', $poll->toArray());
        $this->view->assign('attachment', $attachment->toArray());
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        // Zapis ankiety i załącznika
        if ($this->_request->isPost()) {
            $formRawData = $this->_request->getPost('form');
            $attachRawData = $this->_request->getPost('attach');
            // Filtracja danych
            $pollData = array();
            $attachData = array();
            foreach ($formRawData as $key => $value) {
                $tmp = array();
                if (isset($value['answer'])) {
                    $tmp['answer'] = trim(strip_tags($value['answer']));
                }
                if (isset($value['comment'])) {
                    $tmp['comment'] = trim(strip_tags($value['comment']));
                }
                $pollData[$key] = $tmp;
            }
            foreach ($attachRawData as $key => $value) {
                $attachData[$key]['answer'] = trim(strip_tags($value['answer']));
            }
            // Walidacja
            $pollInfo = $poll->validateData($pollData);
            $attachInfo = $attachment->validateData($attachData);
            if (!$pollInfo['status'] || !$attachInfo['status']) {
                $attachMsgs = array();
                if (!$attachInfo['status']) {
                    foreach ($attachInfo['messages'] as $key => $value) {
                        $idParts = explode('_', $key);
                        $attachMsgs[$idParts[0]] = $value;
                    }
                }
                $this->view->assign('pollData', $pollData);
                $this->view->assign('pollMsgs', $pollInfo['messages']);
                $this->view->assign('attachData', $attachData);
                $this->view->assign('attachMsgs', $attachMsgs);
                return;
            }
            $db = $this->getInvokeArg('bootstrap')->getResource('db');
            try {
                $db->beginTransaction();
                $savePollStatus = $poll->saveAnswers($pollData, $this->_account->getId());
                $saveAttachStatus = $attachment->saveAnswers($attachData, $this->_account->getId());
                $db->commit();
            } catch (Exception $exc) {
                $db->rollBack();
                $this->_flash->addMessage('Wystąpiły błędy podczas zapisu ankiety');
                $this->_redirect($this->_helper->url->url(array()));
            }
            $this->_flash->addMessage('Ankieta została pomyślnie zapisana');
            $this->_redirect($this->_helper->url->url(array('action'=>'summary')));
        }
    }

    public function prepareAfterAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $logbook = new Moto_Model_Logbook($this->_account->getId());
        // Uczestnik nie zakończył warsztatów
        if (Moto_Model_Logbook::TIME_STATUS_AFTER != $logbook->getPrepareStatus()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        // Ankietę można wypełnić tylko raz
        if (Moto_Model_Poll_Manager::hasUserCompleted($this->_account->getId(), Moto_Model_Poll_Manager::ID_PREPARE_AFTER)) {
            $this->_redirect($this->_helper->url->url(array('action' => 'prepare-after-pdf')));
        }
        $poll = Moto_Model_Poll_Manager::getById(Moto_Model_Poll_Manager::ID_PREPARE_AFTER);
        $this->view->assign('poll', $poll->toArray());
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        if ($this->_request->isPost()) {
            $formRawData = $this->_request->getPost('form');
            // Filtracja danych
            $pollData = array();
            foreach ($formRawData as $key => $value) {
                $tmp = array();
                if (isset($value['answer'])) {
                    $tmp['answer'] = trim(strip_tags($value['answer']));
                }
                if (isset($value['comment'])) {
                    $tmp['comment'] = trim(strip_tags($value['comment']));
                }
                $pollData[$key] = $tmp;
            }
            // Walidacja
            $pollInfo = $poll->validateData($pollData);
            if (!$pollInfo['status']) {
                $this->view->assign('pollData', $pollData);
                $this->view->assign('pollMsgs', $pollInfo['messages']);
                return;
            }
            $db = $this->getInvokeArg('bootstrap')->getResource('db');
            try {
                $db->beginTransaction();
                $savePollStatus = $poll->saveAnswers($pollData, $this->_account->getId());
                $db->commit();
            } catch (Exception $exc) {
                $db->rollBack();
                $this->_flash->addMessage('Wystąpiły błędy podczas zapisu ankiety');
                $this->_redirect($this->_helper->url->url(array()));
            }
            $this->_flash->addMessage('Ankieta została pomyślnie zapisana');
            $this->_redirect($this->_helper->url->url(array('action'=>'summary')));
        }
    }

    public function summaryAction()
    {
        $msgs = $this->_flash->getMessages();
        $profileUrl = $this->_helper->url->url(array(
            'controller' => 'profile',
            'action' => 'index'
        ));
        if (empty($msgs)) {
            $this->_redirect($profileUrl);
        }
        $this->view->assign('profileUrl', $profileUrl);
    }

    public function practiceBeforePdfAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $poll = Moto_Model_Poll_Manager::getById(Moto_Model_Poll_Manager::ID_PRACTICE_BEFORE);
        $answers = Moto_Model_Poll_Manager::getUserAnswers($this->_account->getId(), Moto_Model_Poll_Manager::ID_PRACTICE_BEFORE);

        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $this->_response->setHeader('Content-type', 'application/pdf');
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/poll/');
        $view->assign('domain', 'http://'.$this->_request->getServer('HTTP_HOST'));
        $view->assign('poll', $poll->toArray());
        $view->assign('data', $answers);
        $html = $view->render('practice-before-pdf.phtml');
        require_once("dompdf/dompdf_config.inc.php");
        $dompdf = new DOMPDF();
        $dompdf->load_html($html, 'utf-8');
        $dompdf->render();
        echo $dompdf->output();
    }

    public function prepareBeforePdfAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $poll = Moto_Model_Poll_Manager::getById(Moto_Model_Poll_Manager::ID_PREPARE_BEFORE);
        $answers = Moto_Model_Poll_Manager::getUserAnswers($this->_account->getId(), Moto_Model_Poll_Manager::ID_PREPARE_BEFORE);

        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $this->_response->setHeader('Content-type', 'application/pdf');
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/poll/');
        $view->assign('domain', 'http://'.$this->_request->getServer('HTTP_HOST'));
        $view->assign('poll', $poll->toArray());
        $view->assign('data', $answers);
        $html = $view->render('prepare-before-pdf.phtml');
        require_once("dompdf/dompdf_config.inc.php");
        $dompdf = new DOMPDF();
        $dompdf->load_html($html, 'utf-8');
        $dompdf->render();
        echo $dompdf->output();
    }

    public function practiceAfterPdfAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $logbook = new Moto_Model_Logbook($this->_account->getId());
        $poll = Moto_Model_Poll_Manager::getById(Moto_Model_Poll_Manager::ID_PRACTICE_AFTER);
        $answers = Moto_Model_Poll_Manager::getUserAnswers($this->_account->getId(), Moto_Model_Poll_Manager::ID_PRACTICE_AFTER);
        $profession = $logbook->getProfession();
        $motoConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/moto.ini', APPLICATION_ENV);
        $attachmentId = $motoConfig->pollAttachment->{$profession}->id;
        if (null === $attachmentId) {
            $this->_flash->addMessage('Nieprawidłowy plik załącznika do ankiety');
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'regular'
            )));
        }
        $attachment = Moto_Model_Poll_Manager::getAttachmentById($attachmentId);
        $attachData = Moto_Model_Poll_Manager::getUserAttachmentAnswers($this->_account->getId(), $attachmentId);

        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $this->_response->setHeader('Content-type', 'application/pdf');
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/poll/');
        $view->assign('domain', 'http://'.$this->_request->getServer('HTTP_HOST'));
        $view->assign('poll', $poll->toArray());
        $view->assign('attachment', $attachment->toArray());
        $view->assign('data', $answers);
        $view->assign('attachData', $attachData);
        $html = $view->render('practice-after-pdf.phtml');
        require_once("dompdf/dompdf_config.inc.php");
        $dompdf = new DOMPDF();
        $dompdf->load_html($html, 'utf-8');
        $dompdf->render();
        echo $dompdf->output();
    }

    public function prepareAfterPdfAction()
    {
        // Dostęp tylko dla uczestnika praktyk
        if (Moto_Model_Account::ROLE_REGULAR != $this->_account->getRole()) {
            $this->_redirect($this->_helper->url->url(array(
                'controller' => 'profile',
                'action' => 'index'
            )));
        }
        $poll = Moto_Model_Poll_Manager::getById(Moto_Model_Poll_Manager::ID_PREPARE_AFTER);
        $answers = Moto_Model_Poll_Manager::getUserAnswers($this->_account->getId(), Moto_Model_Poll_Manager::ID_PREPARE_AFTER);

        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $this->_response->setHeader('Content-type', 'application/pdf');
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/poll/');
        $view->assign('domain', 'http://'.$this->_request->getServer('HTTP_HOST'));
        $view->assign('poll', $poll->toArray());
        $view->assign('data', $answers);
        $html = $view->render('prepare-after-pdf.phtml');
        require_once("dompdf/dompdf_config.inc.php");
        $dompdf = new DOMPDF();
        $dompdf->load_html($html, 'utf-8');
        $dompdf->render();
        echo $dompdf->output();
    }
}