<?php
class Moto_Model_Account_Controller extends Zend_Controller_Action
{
    protected $_account;

    public function __construct(Zend_Controller_Request_Abstract $request, Zend_Controller_Response_Abstract $response, array $invokeArgs = array())
    {
        $this->setRequest($request)
             ->setResponse($response)
             ->_setInvokeArgs($invokeArgs);
        $this->_helper = new Zend_Controller_Action_HelperBroker($this);
        $this->_account = Moto_Model_Account_Factory::getByAuth();
        $loggedId = (!empty($this->_account)) ? $this->_account->getId() : 0;
        $this->view->assign('loggedId', $loggedId);
        if (!empty($this->_account)) {
            $this->view->assign('account', $this->_account);
            $this->view->assign('accountInfo', $this->_account->getBaseData());
        }
        $this->init();
    }
}