<?php
class Moto_Model_Account_Factory
{
    public static function getByAuth()
    {
        $id = Zend_Auth::getInstance()->getIdentity();
        if (empty($id)) {
            return null;
        }
        $usersTable = new Moto_Model_Table_Users();
        $user = $usersTable->getByEmail($id);
        $account = self::getByRole($user->role);
        $account->setStore($user);
        return $account;
    }

    public static function getByRole($role)
    {
        $className = 'Moto_Model_Account_'.ucfirst($role);
        return new $className();
    }
}