<?php
class Moto_Model_Account_Regular extends Moto_Model_Account
{
    public function getBaseData()
    {
        if (empty($this->_store)) {
            return array();
        }
        $response = array(
            'email' => $this->_store->email,
            'full_register_date' => $this->_store->full_register_date
        );
        $formsTable = new Moto_Model_Table_RegisterForm();
        $form = $formsTable->getByUserId($this->_store->id);
        if (null === $form) {
            return $response;
        }
        $response['first_name'] = $form['first_name'];
        $response['second_name'] = $form['second_name'];
        $response['last_name'] = $form['last_name'];
        return $response;
    }

    public function getPresentationUploadDate()
    {
        $logTable = new Moto_Model_Table_Logbook();
        $select = $logTable->select()->where('user_id = ?', $this->_store->id);
        $log = $logTable->fetchRow($select);
        if (null === $log) {
            return null;
        }
        return $log->presentation_upload_date;
    }

    public function getReminder()
    {
        if (empty($this->_store)) {
            return array();
        }
        $content = array();
        $logbook = new Moto_Model_Logbook($this->_store->id);
        if (Moto_Model_Logbook::TIME_STATUS_AFTER == $logbook->getPracticeStatus() && !Moto_Model_Poll_Manager::hasUserCompleted($this->_store->id, Moto_Model_Poll_Manager::ID_PRACTICE_AFTER)) {
            $content[] = 'Uwaga: Wypełnij ankietę po zakończonych praktykach!';
        }
        if (Moto_Model_Logbook::TIME_STATUS_AFTER == $logbook->getPrepareStatus() && !Moto_Model_Poll_Manager::hasUserCompleted($this->_store->id, Moto_Model_Poll_Manager::ID_PREPARE_AFTER)) {
            $content[] = 'Uwaga: Wypełnij ankietę po zakończonych warsztatach!';
        }
        return $content;
    }
}