<?php
class Moto_Model_Account_Tutor extends Moto_Model_Account
{
    public function getBaseData()
    {
        if (empty($this->_store)) {
            return array();
        }
        $response = array(
            'email' => $this->_store->email,
            'full_register_date' => $this->_store->full_register_date
        );
        $contactTable = new Moto_Model_Table_ContactData();
        $contactInfo = $contactTable->getByUserId($this->_store->id);
        $response['first_name'] = (null === $contactInfo) ? 'Nie uzupełniono' : $contactInfo->first_name;
        $response['last_name'] = (null === $contactInfo) ? 'Nie uzupełniono' : $contactInfo->last_name;
        return $response;
    }

    public function getAssignedUsers()
    {
        if (empty($this->_store)) {
            return array();
        }
        $allocTable = new Moto_Model_Table_TutorAllocation();
        $formsTable = new Moto_Model_Table_RegisterForm();
        $db = $allocTable->getAdapter();
        $select = $db->select()
            ->from(array('a'=>$allocTable->info('name')), array(
                'user_id' => 'a.user_id',
                'user_first_name' => 'f.first_name',
                'user_last_name' => 'f.last_name',
                'user_place' => 'f.registered_place'
            ))
            ->joinLeft(array('f'=>$formsTable->info('name')), 'f.id = a.form_id')
            ->where('tutor_id = ?', $this->_store->id);
        $result = $db->fetchAll($select);
        return $result;
    }

    public function isUserAssigned($userId)
    {
        $allocTable = new Moto_Model_Table_TutorAllocation();
        return $allocTable->asignmentExists($this->_store->id, $userId);
    }
}