<?php
class Moto_Model_Facade
{
    const DATETIME_FORMAT = 'Y-m-d H:i:s';

    const HASH_SEED = 'asdjiqowdjaslk';

    const LINK_SEND_LIMIT = 10;

    private $_messages;

    public function __construct()
    {
        $this->_messages = new Zend_Config_Ini(APPLICATION_PATH.'/configs/messages.ini', APPLICATION_ENV);
    }

    public function simpleRegisterValidate($data)
    {
        $filtered = array();
        $status = true;
        $messages = array();
        foreach ($data as $key => $value) {
            $filtered[$key] = trim(strip_tags($value));
        }
        if (!Zend_Validate::is($filtered['email'], 'EmailAddress')) {
            $status = false;
            $messages['email'] = $this->_messages->email->invalid;
        }
        if (empty($filtered['password']) || '' == $filtered['password']) {
            $status = false;
            $messages['password'] = $this->_messages->password->empty;
        } else {
            if ($filtered['password'] != $filtered['passwordRepeat']) {
                $status = false;
                $messages['password'] = $this->_messages->password->repeatNotMatch;
            }
        }
        $users = new Moto_Model_Table_Users();
        if ($users->emailExists($filtered['email'])) {
            $status = false;
            $messages['email'] = $this->_messages->email->alreadyRegistered;
        }
        return array(
            'status' => $status,
            'messages' => $messages,
            'filtered' => $filtered
        );
    }

    public function remindFormValidate($data)
    {
        $filtered = array();
        $status = true;
        $messages = array();
        foreach ($data as $key => $value) {
            $filtered[$key] = trim(strip_tags($value));
        }
        if (!Zend_Validate::is($filtered['email'], 'EmailAddress')) {
            $status = false;
            $messages['email'] = $this->_messages->email->invalid;
        }
        if (empty($filtered['password']) || '' == $filtered['password']) {
            $status = false;
            $messages['password'] = $this->_messages->password->empty;
        }
        if (!$status) {
            return array(
                'status' => $status,
                'messages' => $messages,
                'filtered' => $filtered
            );
        }
        $users = new Moto_Model_Table_Users();
        $user = $users->getByEmail($filtered['email']);
        if (null === $user) {
            $status = false;
            $messages['email'] = $this->_messages->credentials->invalid;
            return array(
                'status' => $status,
                'messages' => $messages,
                'filtered' => $filtered
            );
        }
        if (sha1($filtered['password']) != $user->password_hash) {
            $status = false;
            $messages['password'] = $this->_messages->credentials->invalid;
        }
        if (self::LINK_SEND_LIMIT == $user->link_sent_count) {
            $status = false;
            $messages['email'] = $this->_messages->linkSentLimit;
        }
        return array(
            'status' => $status,
            'messages' => $messages,
            'filtered' => $filtered
        );
    }

    public function sendRemindMail($data, $baseUrl)
    {
        $users = new Moto_Model_Table_Users();
        $user = $users->getByEmail($data['email']);
        if (null === $user) {
            return false;
        }
        $this->sendSimpleRegisterMail($user->toArray(), $baseUrl);
        $user->link_sent_count = $user->link_sent_count + 1;
        $user->save();
        return true;
    }

    /**
     * Wykonanie wstępnej rejestracji w bazie
     */
    public function simpleRegisterDo($data, $baseUrl)
    {
        $users = new Moto_Model_Table_Users();
        $db = $users->getAdapter();

	try {
            $db->beginTransaction();
            $row = $users->createRow();
            $now = time();
            $row->email = $data['email'];
            $row->password_hash = sha1($data['password']);
            $row->url_hash = md5($data['email']).'_'.sha1($now.self::HASH_SEED);
            $row->simple_register_date = date(self::DATETIME_FORMAT, $now);
            $id = $row->save();
            if (0 >= $id) {
                throw new Exception('Błąd zapisu danych podczas wstępnej rejestracji');
            }
            $this->sendSimpleRegisterMail($row->toArray(), $baseUrl);
            $row->link_sent_date = date(self::DATETIME_FORMAT);
            $row->link_sent_count = $row->link_sent_count + 1;
            $row->save();
            $db->commit();
        } catch (Exception $exc) {
            $db->rollBack();
            return false;
        }
        return true;
    }

    public function tutorRegister($data, $link)
    {
        $users = new Moto_Model_Table_Users();
        $db = $users->getAdapter();
        try {
            $db->beginTransaction();
            $row = $users->createRow();
            $now = time();
            $row->email = $data['email'];
            $row->password_hash = sha1($data['password']);
            $row->url_hash = md5($data['email']).'_'.sha1($now.self::HASH_SEED);
            $row->simple_register_date = date(self::DATETIME_FORMAT, $now);
            $row->role = Moto_Model_Account::ROLE_TUTOR;
            $row->active = 0;
            $id = $row->save();
            if (0 >= $id) {
                throw new Exception('Błąd zapisu danych podczas rejestracji');
            }
            $this->sendTutorRegisterMail($row->toArray(), $link);
            $row->link_sent_date = date(self::DATETIME_FORMAT);
            $row->link_sent_count = $row->link_sent_count + 1;
            $row->save();
            $db->commit();
        } catch (Exception $exc) {
            $db->rollBack();
            return false;
        }
        return true;
    }

    public function expertRegister($data, $link)
    {
        $users = new Moto_Model_Table_Users();
        $db = $users->getAdapter();
        try {
            $db->beginTransaction();
            $row = $users->createRow();
            $now = time();
            $row->email = $data['email'];
            $row->password_hash = sha1($data['password']);
            $row->url_hash = md5($data['email']).'_'.sha1($now.self::HASH_SEED);
            $row->simple_register_date = date(self::DATETIME_FORMAT, $now);
            $row->role = Moto_Model_Account::ROLE_EXPERT;
            $row->active = 0;
            $id = $row->save();
            if (0 >= $id) {
                throw new Exception('Błąd zapisu danych podczas rejestracji');
            }
            $this->sendExpertRegisterMail($row->toArray(), $link);
            $row->link_sent_date = date(self::DATETIME_FORMAT);
            $row->link_sent_count = $row->link_sent_count + 1;
            $row->save();
            $db->commit();
        } catch (Exception $exc) {
            $db->rollBack();
            return false;
        }
        return true;
    }

    public function savePresentation($log)
    {
        try {
            if (!$log->hasBaseData()) {
                return array(
                    'status' => false,
                    'message' => 'Uczestnik nie ma wypełnionego dziennika praktyk'
                );
            }
            if (0 < $_FILES['presentation']['error']) {
                return array(
                    'status' => false,
                    'message' => 'Wystąpił błąd podczas zapisu pliku'
                );
            }
            $mimeTypes = array(
                'application/vnd.ms-powerpoint',
                'application/vnd.openxmlformats-officedocument.presentationml.presentation'
            );
            $allowedExt = array('ppt', 'pptx');
            if (!in_array($_FILES['presentation']['type'], $mimeTypes)) {
                return array(
                    'status' => false,
                    'message' => 'Niedozwolony format prezentacji'
                );
            }
            $ext = end(explode('.', $_FILES['presentation']['name']));
            if (!in_array($ext, $allowedExt)) {
                return array(
                    'status' => false,
                    'message' => 'Niedozwolone rozszerzenie pliku'
                );
            }
            $userId = $log->getUserId();
            $filename = 'prezentacja_'.$userId.'_'.sha1($userId.time()).'.'.$ext;
            $ctrl = move_uploaded_file($_FILES['presentation']['tmp_name'], PUBLIC_PATH.'/files/'.$filename);
            if (!$ctrl) {
                return array(
                    'status' => false,
                    'message' => 'Wystąpił błąd podczas zapisu pliku.'
                );
            }
            $log->setPresentationFilename($filename)->setPresentationDate(date('Y-m-d H:i:s'))->saveBase();
            return array(
                'status' => true,
                'message' => 'Prezentacja została zapisana'
            );
        } catch (Exception $exc) {
            return array(
                'status' => false,
                'message' => $exc->getMessage()
            );
        }
    }

    // @todo Zrefaktoryzować metody wysyłające maile do dwóch metod z odpowiednimi parametrami
    //       lub użyć statycznej metody sendTo klasy Moto_Model_Mailer
	 // KRS -> wysylka przekazana do Moto_Model_Mailer>send

    public function sendTutorRegisterNotification($to, $data = array())
    {
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/email/');
        $html = $view->render('tutor-admin-notification.phtml');

		  $mail = new Moto_Model_Mailer();
		  $mail->send($html, array('email'=>$to, 'subject'=>'Nowe konto opiekuna praktyk'));
    }

    public function sendTutorReportNotification($to, $data)
    {
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/email/');
        $view->assign('data', $data);
        $html = $view->render('tutor-report-notification.phtml');

		  $mail = new Moto_Model_Mailer();
		  $mail->send($html, array('email'=>$to, 'subject'=>'Nowe sprawozdanie uczestnika praktyk'));
    }

    private function sendSimpleRegisterMail($userData, $link)
    {
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/email/');
        $view->assign('formUrl', $link.'/key/'.$userData['url_hash'].'/first/true');
        $html = $view->render('simple-register.phtml');

		  $mail = new Moto_Model_Mailer();
		  $mail->send($html, array('email'=>$userData['email'], 'subject'=>'Kompetentni nauczyciele kształcenia zawodowego branży motoryzacyjnej - rekrutacja'));
    }

    private function sendTutorRegisterMail($userData, $link)
    {
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/email/');
        $view->assign('formUrl', $link.'/key/'.$userData['url_hash']);
        $html = $view->render('tutor-register.phtml');

		  $mail = new Moto_Model_Mailer();
		  $mail->send($html, array('email'=>$userData['email'], 'subject'=>'Potwierdź swoją rejestrację'));
    }

    private function sendExpertRegisterMail($userData, $link)
    {
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/email/');
        $view->assign('formUrl', $link.'/key/'.$userData['url_hash']);
        $html = $view->render('expert-register.phtml');

		  $mail = new Moto_Model_Mailer();
		  $mail->send($html, array('email'=>$userData['email'], 'subject'=>'Potwierdź swoją rejestrację'));
    }

    public function sendExpertRegisterNotification($to, $data = array())
    {
        $view = new Zend_View();
        $view->setScriptPath(APPLICATION_PATH.'/views/scripts/email/');
        $html = $view->render('expert-admin-notification.phtml');

		  $mail = new Moto_Model_Mailer();
		  $mail->send($html, array('email'=>$to, 'subject'=>'Nowe konto eksperta branżowego'));
    }

    public function getCompletionData($userId)
    {
        $config = new Zend_Config_Ini(APPLICATION_PATH.'/configs/moto.ini', APPLICATION_ENV);
        $formTable = new Moto_Model_Table_RegisterForm();
        $logTable = new Moto_Model_Table_Logbook();
        $form = $formTable->getByUserId($userId);
        $formData = $form->toArray();
        $fullName = $formData['first_name'];
        if (!empty($formData['second_name'])) {
            $fullName = $fullName.' '.$formData['second_name'];
        }
        $fullName = $fullName.' '.$formData['last_name'];
        $log = $logTable->getByUserId($userId);
        $logData = $log->toarray();
        if (10 > $formData['id']) {
            $logNumber = '00'.$formData['id'];
        } elseif (10 <= $formData['id'] && 100 > $formData['id']) {
            $logNumber = '0'.$formData['id'];
        } elseif (100 <= $formData['id']) {
            $logNumber = $formData['id'];
        }
        $regNumber = $logNumber.'/MP/Z/2013';
        $classes = $config->classes->{$logData['profession']}->toArray();
        return array(
            'form' => $formData,
            'gender' => $formData['gender'],
            'fullName' => $fullName,
            'birthDateParts' => explode('-', $formData['birth_date']),
            'profession' => $config->job->map->{$logData['profession']},
            'registryNumber' => $regNumber,
            'classes' => $classes
        );
    }
}