<?php
class Moto_Model_Poll
{
    protected $_id;

    protected $_xml;

    protected $_questions;

    protected $_title;

    protected $_description;

    public function __construct($id)
    {
        $this->_id = $id;
        $this->_loadData();
    }

    public function validateData($data)
    {
        $messages = array();
        $status = true;
        foreach ($this->_questions as $qId => $qContent) {
            if (isset($qContent['complex']) && 1 == $qContent['complex']) {
                foreach ($qContent['subquestions'] as $subKey => $subQuest) {
                    if (0 == $subQuest['required']) {
                        continue;
                    }
                    if (!isset($data[$subKey]['answer']) || empty($data[$subKey]['answer'])) {
                        $status = false;
                        $messages[$subKey] = 'Pytanie obowiązkowe';
                    }
                }
            } else {
                if (0 == $qContent['required']) {
                    continue;
                }
                if (!isset($data[$qId]['answer']) || empty($data[$qId]['answer'])) {
                    $status = false;
                    $messages[$qId] = 'Pytanie obowiązkowe';
                }
            }
        }
        if (isset($data['q_school']['comment']) && empty($data['q_school']['comment'])) {
            $status = false;
            $messages['q_school'] = 'Podaj nazwę i adres szkoły';
        }
        return array(
            'status' => $status,
            'messages' => $messages
        );
    }

    public function saveAnswers($data, $userId)
    {
        $pollTable = new Moto_Model_Table_UserPoll();
        $answerTable = new Moto_Model_Table_PollAnswer();
        $ctrl = $pollTable->insert(array(
            'user_id' => $userId,
            'poll_id' => $this->_id,
            'added_date' => date('Y-m-d H:i:s')
        ));
        if (0 >= $ctrl) {
            throw new Exception('Błąd zapisu podstawowych danych ankiety');
        }
        foreach ($data as $key => $value) {
            $answerTable->insert(array(
                'user_id' => $userId,
                'poll_id' => $this->_id,
                'question_id' => $key,
                'answer_id' => isset($value['answer']) ? $value['answer'] : 0,
                'comment' => (isset($value['comment']) && !empty($value['comment'])) ? $value['comment'] : null
            ));
        }
        return true;
    }

    public function toArray()
    {
        return array(
            'id' => $this->_id,
            'title' => $this->_title,
            'description' => $this->_description,
            'questions' => $this->_questions
        );
    }

    protected function _loadData()
    {
        $this->_xml = new Zend_Config_Xml(APPLICATION_PATH.'/data/polls/'.$this->_id.'.xml', null);
        if ($this->_id != $this->_xml->id) {
            throw new Exception('Niezgodne identyfikatory ankiety');
        }
        $this->_title = $this->_xml->title;
        $this->_description = $this->_xml->description;
        $this->_questions = $this->_xml->questions->toArray();
    }
}