<?php
class Moto_Model_Poll_Attachment extends Moto_Model_Poll
{
    public function saveAnswers($data, $userId)
    {
        $attachTable = new Moto_Model_Table_PollAttachment();
        $dataTable = new Moto_Model_Table_AttachmentData();
        $ctrl = $attachTable->insert(array(
            'user_id' => $userId,
            'attachment_id' => $this->_id,
            'add_date' => date('Y-m-d H:i:s')
        ));
        if (0 >= $ctrl) {
            throw new Exception('Wystąpiły błędy podczas zapisu danych załącznika');
        }
        foreach ($data as $key => $value) {
            $dataTable->insert(array(
                'user_id' => $userId,
                'attachment_id' => $this->_id,
                'question_id' => $key,
                'content' => $value['answer']
            ));
        }
        return true;
    }

    protected function _loadData()
    {
        parent::_loadData();
        $this->_description = $this->_xml->description->toArray();
    }
}