<?php
class Moto_Model_Poll_Manager
{
    const ID_PRACTICE_BEFORE = 'practice-before';
    const ID_PREPARE_BEFORE = 'prepare-before';
    const ID_PRACTICE_AFTER = 'practice-after';
    const ID_PREPARE_AFTER = 'prepare-after';
    const ID_ATTACHMENT_REPAIR = 'attachment-repair';
    const ID_ATTACHMENT_THINSMITH = 'attachment-thinsmith';
    const ID_ATTACHMENT_DIAGNOSTIC = 'attachment-diagnostic';
    const ID_ATTACHMENT_ELECTRO = 'attachment-electro';

    public static function hasUserCompleted($userId, $pollId)
    {
        $pollTable = new Moto_Model_Table_UserPoll();
        return $pollTable->userPollExists($userId, $pollId);
    }

    public static function getById($id)
    {
        $poll = new Moto_Model_Poll($id);
        return $poll;
    }

    public static function getAttachmentById($id)
    {
        $attachment = new Moto_Model_Poll_Attachment($id);
        return $attachment;
    }

    public static function getUserAnswers($userId, $pollId)
    {
        $pollTable = new Moto_Model_Table_UserPoll();
        $answerTable = new Moto_Model_Table_PollAnswer();
        $baseRow = $pollTable->getUserPoll($userId, $pollId);
        if (null === $baseRow) {
            throw new Exception('Nieprawidłowe dane identyfikacyjne ankiety');
        }
        $out = array();
        $out['pollData'] = $baseRow->toArray();
        $answers = $answerTable->getUserAnswers($userId, $pollId);
        $formatted = array();
        foreach ($answers as $value) {
            $formatted[$value['question_id']] = $value;
        }
        $out['answers'] = $formatted;
        return $out;
    }

    public static function getUserAttachmentAnswers($userId, $attachId)
    {
        $mainTable = new Moto_Model_Table_PollAttachment();
        $dataTable = new Moto_Model_Table_AttachmentData();
        $mainRow = $mainTable->getUserAttachment($userId, $attachId);
        if (null === $mainRow) {
            throw new Exception('Nieprawidłowe dane identyfikacyjne załącznika');
        }
        $out = array();
        $out['attachData'] = $mainRow->toArray();
        $answers = $dataTable->getUserAnswers($userId, $attachId);
        $formatted = array();
        foreach ($answers as $value) {
            $formatted[$value['question_id']] = $value;
        }
        $out['answers'] = $formatted;
        return $out;
    }

    public static function getRatedQuestions($pollId)
    {
        $poll = new Moto_Model_Poll($pollId);
        $pollData = $poll->toArray();
        $quests = array();
        foreach ($pollData['questions'] as $qId => $qData) {
            if (isset($qData['complex']) && 1 == $qData['complex']) {
                foreach ($qData['subquestions'] as $subQId => $subQData) {
                    if (!isset($subQData['rated']) || 0 == $subQData['rated']) {
                        continue;
                    }
                    $quests[$subQId] = $subQData;
                }
            } else {
                if (!isset($qData['rated']) || 0 == $qData['rated']) {
                    continue;
                }
                $quests[$qId] = $qData;
            }
        }
        return $quests;
    }

    public static function getAttachmentRatedQuestions($id)
    {
        $attachment = new Moto_Model_Poll_Attachment($id);
        $data = $attachment->toArray();
        $quests = array();
        $quests['title'] = $data['title'];
        $quests['description'] = $data['description']['content'];
        $quests['questions'] = array();
        foreach ($data['questions'] as $qId => $qData) {
            $quests['questions'][$qId]['content'] = $qData['content'];
            if (isset($qData['complex']) && 1 == $qData['complex']) {
                foreach ($qData['subquestions'] as $subQId => $subQData) {
                    if (!isset($subQData['rated']) || 0 == $subQData['rated']) {
                        continue;
                    }
                    $quests['questions'][$qId]['data'][$subQId] = $subQData;
                }
            } else {
                if (!isset($qData['rated']) || 0 == $qData['rated']) {
                    continue;
                }
                $quests['questions'][$qId]['data'][$qId] = $qData;
            }
        }
        return $quests;
    }
}