<?php
class Moto_Model_Register_FormData
{
    private $_rawData = array();

    private $_filtered = array();

    private $_messages = array();

    private $_status;

    private $_msgMap;

    private $_gender = array('female', 'male');
    private $_placeTypes = array('city', 'village');
    private $_education = array(
        'secondarypedagog',
        'highervocational',
        'masters',
        'higherpedagog'
    );

    public function __construct($data)
    {
        $this->setData($data);
    }

    public function setData($data)
    {
        $this->_rawData = $data;
        $this->_filter();
    }

    public function setMessagesMap(array $messagesMap)
    {
        $this->_msgMap = $messagesMap;
        return $this;
    }

    public function getFiltered()
    {
        return $this->_filtered;
    }

    public function getMessages()
    {
        return $this->_messages;
    }

    public function isValid()
    {
        $this->_validate();
        return $this->_status;
    }

    public function calcPoints()
    {
        if (empty($this->_filtered)) {
            return 0;
        }
        $points = 0;
        if (1 == $this->_filtered['age45plus']) {
            $points = $points + 10;
        }
        if (1 == $this->_filtered['none_practice']) {
            $points = $points + 10;
        }
        return $points;
    }

    private function _filter()
    {
        $this->_filtered = array();
        foreach ($this->_rawData as $key => $value) {
            $this->_filtered[$key] = trim(strip_tags($value));
        }
        $this->_filtered['gender'] = (!isset($this->_filtered['gender'])) ? null : strtolower($this->_filtered['gender']);
        $this->_filtered['care'] = (!isset($this->_filtered['care'])) ? null : (int) $this->_filtered['care'];
        $this->_filtered['registered_place_type'] = (!isset($this->_filtered['registered_place_type'])) ? null : strtolower($this->_filtered['registered_place_type']);
        $this->_filtered['residence_place_type'] = (!isset($this->_filtered['residence_place_type'])) ? null : strtolower($this->_filtered['residence_place_type']);
        $this->_filtered['disability'] = (!isset($this->_filtered['disability'])) ? null : (int) $this->_filtered['disability'];
        $this->_filtered['education'] = (!isset($this->_filtered['education'])) ? null : strtolower($this->_filtered['education']);
        $this->_filtered['car_technician'] = (!isset($this->_filtered['car_technician'])) ? 0 : (int) $this->_filtered['car_technician'];
        $this->_filtered['car_mechanic'] = (!isset($this->_filtered['car_mechanic'])) ? 0 : (int) $this->_filtered['car_mechanic'];
        $this->_filtered['car_electro_mechanic'] = (!isset($this->_filtered['car_electro_mechanic'])) ? 0 : (int) $this->_filtered['car_electro_mechanic'];
        $this->_filtered['car_thinsmith'] = (!isset($this->_filtered['car_thinsmith'])) ? 0 : (int) $this->_filtered['car_thinsmith'];
        $this->_filtered['age45plus'] = (!isset($this->_filtered['age45plus'])) ? null : (int) $this->_filtered['age45plus'];
        $this->_filtered['none_practice'] = (!isset($this->_filtered['none_practice'])) ? null : (int) $this->_filtered['none_practice'];
        $this->_filtered['age'] = (!isset($this->_filtered['age'])) ? null : (int) $this->_filtered['age'];
        $this->_filtered['preferred_date'] = (!isset($this->_filtered['preferred_date'])) ? 0 : (int) $this->_filtered['preferred_date'];
        $this->_filtered['preferredWorkshop_date'] = (!isset($this->_filtered['preferredWorkshop_date'])) ? 0 : (int) $this->_filtered['preferredWorkshop_date'];
        $this->_filtered['additional_date'] = (!isset($this->_filtered['additional_date'])) ? 0 : (int) $this->_filtered['additional_date'];
        $this->_filtered['additionalWorkshop_date'] = (!isset($this->_filtered['additionalWorkshop_date'])) ? 0 : (int) $this->_filtered['additionalWorkshop_date'];
        $this->_filtered['personal_agreement'] = (!isset($this->_filtered['personal_agreement'])) ? 0 : (int) $this->_filtered['personal_agreement'];
        $this->_filtered['truth_agreement'] = (!isset($this->_filtered['truth_agreement'])) ? 0 : (int) $this->_filtered['truth_agreement'];
        if (isset($this->_filtered['job_type'])) {
            $this->_filtered['job_type'] = (int) $this->_filtered['job_type'];
            $this->_filtered['teacher'] = (1 == $this->_filtered['job_type']) ? 1 : 0;
            $this->_filtered['instructor'] = (2 == $this->_filtered['job_type']) ? 1 : 0;
            unset($this->_filtered['job_type']);
        } else {
            $this->_filtered['teacher'] = 0;
            $this->_filtered['instructor'] = 0;
        }
    }

    private function _validate()
    {
        $this->_status = true;
        $this->_messages = array();

        if (empty($this->_filtered['first_name'])) {
            $this->_status = false;
            $this->_messages['first_name'] = $this->_msgMap['first_name']['empty'];
        }
        if (empty($this->_filtered['last_name'])) {
            $this->_status = false;
            $this->_messages['last_name'] = $this->_msgMap['last_name']['empty'];
        }
        if (empty($this->_filtered['gender']) || !in_array($this->_filtered['gender'], $this->_gender)) {
            $this->_status = false;
            $this->_messages['gender'] = $this->_msgMap['gender']['empty'];
        }
        if (empty($this->_filtered['birth_date'])) {
            $this->_status = false;
            $this->_messages['birth_date'] = $this->_msgMap['birth_date']['empty'];
        } else {
            if (!$this->_isDateValid($this->_filtered['birth_date'])) {
                $this->_status = false;
                $this->_messages['birth_date'] = $this->_msgMap['date']['invalid'];
            }
        }
        if (empty($this->_filtered['birth_place'])) {
            $this->_status = false;
            $this->_messages['birth_place'] = $this->_msgMap['birth_place']['empty'];
        }
        if (empty($this->_filtered['age'])) {
            $this->_status = false;
            $this->_messages['age'] = $this->_msgMap['age']['empty'];
        } else {
            if (0 >= $this->_filtered['age']) {
                $this->_status = false;
                $this->_messages['age'] = $this->_msgMap['age']['invalid'];
            }
        }
        if (null === $this->_filtered['care']) {
            $this->_status = false;
            $this->_messages['care'] = $this->_msgMap['checkbox']['empty'];
        }
        if (empty($this->_filtered['pesel'])) {
            $this->_status = false;
            $this->_messages['pesel'] = $this->_msgMap['pesel']['empty'];
        } else {
            // @todo Sprawdzić poprawność peselu
            if (!$this->_isPeselValid($this->_filtered['pesel'])) {
                $this->_status = false;
                $this->_messages['pesel'] = $this->_msgMap['pesel']['invalid'];
            }
        }
        if (empty($this->_filtered['registered_street'])) {
            $this->_status = false;
            $this->_messages['registered_street'] = $this->_msgMap['street']['empty'];
        }
        if (empty($this->_filtered['registered_house_number'])) {
            $this->_status = false;
            $this->_messages['registered_house_number'] = $this->_msgMap['house_number']['empty'];
        }
        if (empty($this->_filtered['registered_place'])) {
            $this->_status = false;
            $this->_messages['registered_place'] = $this->_msgMap['place']['empty'];
        }
        if (empty($this->_filtered['registered_place_type'])) {
            $this->_status = false;
            $this->_messages['registered_place_type'] = $this->_msgMap['checkbox']['empty'];
        } else {
            if (!in_array($this->_filtered['registered_place_type'], $this->_placeTypes)) {
                $this->_status = false;
                $this->_messages['registered_place_type'] = $this->_msgMap['checkbox']['empty'];
            }
        }
        if (empty($this->_filtered['registered_postal_code'])) {
            $this->_status = false;
            $this->_messages['registered_postal_code'] = $this->_msgMap['postal_code']['empty'];
        } else {
            $validator = new Zend_Validate_PostCode(array('locale' => 'pl_PL'));
            if (!$validator->isValid($this->_filtered['registered_postal_code'])) {
                $this->_status = false;
                $this->_messages['registered_postal_code'] = $this->_msgMap['postal_code']['invalid'];
            }
        }
        if (empty($this->_filtered['registered_post'])) {
            $this->_status = false;
            $this->_messages['registered_post'] = $this->_msgMap['post']['empty'];
        }
        if (empty($this->_filtered['registered_region'])) {
            $this->_status = false;
            $this->_messages['registered_region'] = $this->_msgMap['region']['empty'];
        }
        if (empty($this->_filtered['registered_district'])) {
            $this->_status = false;
            $this->_messages['registered_district'] = $this->_msgMap['district']['empty'];
        }
        if (empty($this->_filtered['registered_province'])) {
            $this->_status = false;
            $this->_messages['registered_province'] = $this->_msgMap['province']['empty'];
        }
        if (empty($this->_filtered['phone']) && empty($this->_filtered['cell_phone'])) {
            $this->_status = false;
            $this->_messages['phone'] = $this->_msgMap['phone']['empty'];
        } else {
            if (!empty($this->_filtered['phone']) && !preg_match('/^([\d\s-\+\(\)]){1,}$/', $this->_filtered['phone'])) {
                $this->_status = false;
                $this->_messages['phone'] = $this->_msgMap['phone']['invalid'];
            }
            if (!empty($this->_filtered['phone']) && !preg_match('/[\d]+$/', $this->_filtered['phone'])) {
                $this->_status = false;
                $this->_messages['phone'] = $this->_msgMap['phone']['invalid'];
            }
            if (!empty($this->_filtered['cell_phone']) && !preg_match('/^([\d\s-\+\(\)]){1,}$/', $this->_filtered['cell_phone'])) {
                $this->_status = false;
                $this->_messages['cell_phone'] = $this->_msgMap['phone']['invalid'];
            }
            if (!empty($this->_filtered['cell_phone']) && !preg_match('/[\d]+$/', $this->_filtered['cell_phone'])) {
                $this->_status = false;
                $this->_messages['cell_phone'] = $this->_msgMap['phone']['invalid'];
            }
        }
        if (!empty($this->_filtered['fax'])) {
            if (!empty($this->_filtered['fax']) && !preg_match('/^([\d\s-\+\(\)])+$/', $this->_filtered['fax'])) {
                $this->_status = false;
                $this->_messages['fax'] = $this->_msgMap['fax']['invalid'];
            }
            if (!empty($this->_filtered['fax']) && !preg_match('/[\d]+$/', $this->_filtered['fax'])) {
                $this->_status = false;
                $this->_messages['fax'] = $this->_msgMap['fax']['invalid'];
            }
        }
        // Jeśli podano miejscowość zamieszkania, to walidujemy odpowiednie dane miejsca zamieszkania
        if (!empty($this->_filtered['residence_street']) || !empty($this->_filtered['residence_house_number']) || !empty($this->_filtered['residence_place_type']) || !empty($this->_filtered['residence_postal_code']) || !empty($this->_filtered['residence_post']) || !empty($this->_filtered['residence_place']) || !empty($this->_filtered['residence_region']) || !empty($this->_filtered['residence_province']) || !empty($this->_filtered['residence_district'])) {
            if (empty($this->_filtered['residence_street'])) {
                $this->_status = false;
                $this->_messages['residence_street'] = $this->_msgMap['street']['empty'];
            }
            if (empty($this->_filtered['residence_house_number'])) {
                $this->_status = false;
                $this->_messages['residence_house_number'] = $this->_msgMap['house_number']['empty'];
            }
            if (empty($this->_filtered['residence_place_type']) || (!in_array($this->_filtered['residence_place_type'], $this->_placeTypes))) {
                $this->_status = false;
                $this->_messages['residence_place_type'] = $this->_msgMap['checkbox']['empty'];
            }
            if (empty($this->_filtered['residence_postal_code'])) {
                $this->_status = false;
                $this->_messages['residence_postal_code'] = $this->_msgMap['postal_code']['empty'];
            } else {
                $validator = new Zend_Validate_PostCode(array('locale' => 'pl_PL'));
                if (!$validator->isValid($this->_filtered['residence_postal_code'])) {
                    $this->_status = false;
                    $this->_messages['residence_postal_code'] = $this->_msgMap['postal_code']['invalid'];
                }
            }
            if (empty($this->_filtered['residence_post'])) {
                $this->_status = false;
                $this->_messages['residence_post'] = $this->_msgMap['post']['empty'];
            }
            if (empty($this->_filtered['residence_region'])) {
                $this->_status = false;
                $this->_messages['residence_region'] = $this->_msgMap['region']['empty'];
            }
            if (empty($this->_filtered['residence_district'])) {
                $this->_status = false;
                $this->_messages['residence_district'] = $this->_msgMap['district']['empty'];
            }
            if (empty($this->_filtered['residence_province'])) {
                $this->_status = false;
                $this->_messages['residence_province'] = $this->_msgMap['province']['empty'];
            }
        }
        if (null === $this->_filtered['disability']) {
            $this->_status = false;
            $this->_messages['disability'] = $this->_msgMap['checkbox']['empty'];
        }
        if (empty($this->_filtered['education']) || !in_array($this->_filtered['education'], $this->_education)) {
            $this->_status = false;
            $this->_messages['education'] = $this->_msgMap['checkbox']['empty'];
        }
        if (empty($this->_filtered['workplace'])) {
            $this->_status = false;
            $this->_messages['workplace'] = $this->_msgMap['workplace']['empty'];
        }
        $jobs = array(
            $this->_filtered['car_mechanic'],
            $this->_filtered['car_technician'],
            $this->_filtered['car_electro_mechanic'],
            $this->_filtered['car_thinsmith']
        );
        $jobsCtrl = 0;
        foreach ($jobs as $value) {
            $jobsCtrl = $jobsCtrl + (int) $value;
        }
        if (0 == $jobsCtrl) {
            $this->_status = false;
            $this->_messages['job'] = $this->_msgMap['job']['empty'];
        }
        if (empty($this->_filtered['qualifications'])) {
            $this->_status = false;
            $this->_messages['qualifications'] = $this->_msgMap['qualifications']['empty'];
        }
        if (empty($this->_filtered['experience'])) {
            $this->_status = false;
            $this->_messages['experience'] = $this->_msgMap['experience']['empty'];
        }
        if (empty($this->_filtered['preferred_date'])) {
            $this->_status = false;
            $this->_messages['preferred_date'] = $this->_msgMap['preferred_date']['empty'];
        }
        if (empty($this->_filtered['preferredWorkshop_date'])) {
            $this->_status = false;
            $this->_messages['preferredWorkshop_date'] = $this->_msgMap['preferredWorkshop_date']['empty'];
        }
        if (empty($this->_filtered['additional_date'])) {
            $this->_status = false;
            $this->_messages['additional_date'] = $this->_msgMap['additional_date']['empty'];
        }
        if (empty($this->_filtered['additionalWorkshop_date'])) {
            $this->_status = false;
            $this->_messages['additionalWorkshop_date'] = $this->_msgMap['additionalWorkshop_date']['empty'];
        }
        if (0 == $this->_filtered['personal_agreement']) {
            $this->_status = false;
            $this->_messages['personal_agreement'] = $this->_msgMap['mandatory_field'];
        }
        if (0 == $this->_filtered['truth_agreement']) {
            $this->_status = false;
            $this->_messages['truth_agreement'] = $this->_msgMap['mandatory_field'];
        }

        $jobTypeCtrl = $this->_filtered['teacher'] + $this->_filtered['instructor'];
        if (0 == $jobTypeCtrl) {
            $this->_status = false;
            $this->_messages['job_type'] = $this->_msgMap['checkbox']['empty'];
        }
    }

    private function _isDateValid($date)
    {
        $dateParts = explode('-', $date);
        if (3 != count($dateParts)) {
            return false;
        }
        foreach ($dateParts as $value) {
            if (!ctype_digit($value)) {
                return false;
            }
        }

        if (1 > (int)$dateParts[1] || 12 < (int)$dateParts[1]) {
            return false;
        }

        if (1 > (int)$dateParts[2] || 31 < (int)$dateParts[2]) {
            return false;
        }
        return true;
    }

    private function _isEventsSequenceValid($eventA, $eventB)
    {
        $evtAStamp = strtotime($eventA->start_date);
        $evtBStamp = strtotime($eventB->start_date);
        if ($evtAStamp > $evtBStamp) {
            return false;
        }
        return true;
    }

    private function _isPeselValid($pesel)
    {
        if (!preg_match('/^[0-9]{11}$/',$pesel)) {
            return false;
        }
        $arrSteps = array(1, 3, 7, 9, 1, 3, 7, 9, 1, 3);
        $intSum = 0;
        for ($i = 0; $i < 10; $i++) {
            $intSum += $arrSteps[$i] * $pesel[$i];
        }
        $int = 10 - $intSum % 10;
        $intControlNr = ($int == 10)?0:$int;
        if ($intControlNr == $pesel[10]) {
            return true;
        }
        return false;
    }
}