<?php
class Moto_Model_Register_TutorForm
{
    private $_rawData = array();

    private $_filtered = array();

    private $_messages = array();

    private $_status;

    private $_msgMap;

    public function __construct($data)
    {
        $this->setData($data);
    }

    public function setMessagesMap(array $messagesMap)
    {
        $this->_msgMap = $messagesMap;
        return $this;
    }

    public function setData($data)
    {
        $this->_rawData = $data;
        $this->_filter();
    }

    public function getFiltered()
    {
        return $this->_filtered;
    }

    public function getMessages()
    {
        return $this->_messages;
    }

    public function isValid()
    {
        $this->_validate();
        return $this->_status;
    }

    private function _filter()
    {
        $this->_filtered = array();
        foreach ($this->_rawData as $key => $value) {
            $this->_filtered[$key] = trim(strip_tags($value));
        }
    }

    private function _validate()
    {
        $this->_status = true;
        $this->_messages = array();
        if (empty($this->_filtered['first_name'])) {
            $this->_status = false;
            $this->_messages['first_name'] = $this->_msgMap['first_name']['empty'];
        }
        if (empty($this->_filtered['last_name'])) {
            $this->_status = false;
            $this->_messages['last_name'] = $this->_msgMap['last_name']['empty'];
        }
        if (empty($this->_filtered['city'])) {
            $this->_status = false;
            $this->_messages['city'] = $this->_msgMap['place']['empty'];
        }
        if (empty($this->_filtered['house_number'])) {
            $this->_status = false;
            $this->_messages['house_number'] = $this->_msgMap['house_number']['empty'];
        }
        if (empty($this->_filtered['pesel'])) {
            $this->_status = false;
            $this->_messages['pesel'] = $this->_msgMap['pesel']['empty'];
        } else {
            if (!$this->_isPeselValid($this->_filtered['pesel'])) {
                $this->_status = false;
                $this->_messages['pesel'] = $this->_msgMap['pesel']['invalid'];
            }
        }
        if (empty($this->_filtered['postal_code'])) {
            $this->_status = false;
            $this->_messages['postal_code'] = $this->_msgMap['postal_code']['empty'];
        } else {
            $validator = new Zend_Validate_PostCode(array('locale' => 'pl_PL'));
            if (!$validator->isValid($this->_filtered['postal_code'])) {
                $this->_status = false;
                $this->_messages['postal_code'] = $this->_msgMap['postal_code']['invalid'];
            }
        }
        if (empty($this->_filtered['phone'])) {
            $this->_status = false;
            $this->_messages['phone'] = $this->_msgMap['phone']['empty'];
        } else {
            if (!empty($this->_filtered['phone']) && !preg_match('/^([\d\s-\+\(\)]){1,}$/', $this->_filtered['phone'])) {
                $this->_status = false;
                $this->_messages['phone'] = $this->_msgMap['phone']['invalid'];
            }
            if (!empty($this->_filtered['phone']) && !preg_match('/[\d]+$/', $this->_filtered['phone'])) {
                $this->_status = false;
                $this->_messages['phone'] = $this->_msgMap['phone']['invalid'];
            }
        }
    }

    private function _isPeselValid($pesel)
    {
        if (!preg_match('/^[0-9]{11}$/',$pesel)) {
            return false;
        }
        $arrSteps = array(1, 3, 7, 9, 1, 3, 7, 9, 1, 3);
        $intSum = 0;
        for ($i = 0; $i < 10; $i++) {
            $intSum += $arrSteps[$i] * $pesel[$i];
        }
        $int = 10 - $intSum % 10;
        $intControlNr = ($int == 10)?0:$int;
        if ($intControlNr == $pesel[10]) {
            return true;
        }
        return false;
    }
}