<?php
class Moto_Model_Table_ContactData extends Zend_Db_Table
{
    protected $_name = 'contact_data';
    protected $_primary = array('id');

    public function userExists($userId)
    {
        $select = $this->select()->where('user_id = ?', $userId);
        $result = $this->fetchRow($select);
        if (null === $result) {
            return false;
        }
        return true;
    }

    public function registerUser($data)
    {
        $data['update_date'] = date('Y-m-d H:i:s');
        return $this->insert($data);
    }

    public function getByUserId($userId)
    {
        $select = $this->select()->where('user_id = ?', $userId);
        return $this->fetchRow($select);
    }
}