<?php
class Moto_Model_Table_JourneyBill extends Zend_Db_Table
{
    protected $_name = 'journey_bills';
    protected $_primary = array('id');

    public function addPosition($data)
    {
        $insertData = array(
            'create_date' => date('Y-m-d H:i:s'),
            'user_id' => $data['user_id'],
            'departure_date' => $data['departure_date'],
            'route_description' => $data['route_description'],
            'departure_target' => $data['departure_target']
        );
        if (1 == $data['car_option']) {
            $insertData['type'] = 'car';
            $insertData['register_number'] = $data['register_number'];
            $insertData['engine_capacity'] = $data['engine_capacity'];
            $insertData['route_distance'] = $data['route_distance'];
        }
        if (1 == $data['public_option']) {
            $insertData['type'] = 'public';
            $insertData['ticket_price'] = $data['ticket_price'];
            $insertData['transit_count'] = $data['transit_count'];
        }
        return $this->insert($insertData);
    }
}