<?php
class Moto_Model_Table_PollAnswer extends Zend_Db_Table
{
    protected $_name = 'user_poll_answers';
    protected $_primary = array('id');

    public function getUserAnswers($userId, $pollId)
    {
        $select = $this->select()
            ->where('user_id = ?', $userId)
            ->where('poll_id = ?', $pollId);
        return $this->fetchAll($select)->toArray();
    }

    /**
     * Pobranie odpowiedzi do ankiety o podanym id
     *
     * @param int Identyfikator ankiety
     * @param array Identyfikatory pytań (możliwość ograniczenia zbioru odpowiedzi do podanych pytań)
     */
    public function getAnswersByPoll($pollId, $qIds = array())
    {
        $select = $this->select()
            ->where('poll_id = ?', $pollId);
        if (!empty($qIds)) {
            $select->where('question_id IN (?)', $qIds);
        }
        return $this->fetchAll($select)->toArray();
    }
}