<?php
class Moto_Model_Transit_Bill
{
    const BILL_TYPE_CAR = 'car';
    const BILL_TYPE_PUBLIC = 'public';

    private $_billTable;

    private $_userId;

    private $_positions = array();

    private $_config;

    public function __construct($userId, $config)
    {
        $this->_userId = $userId;
        $this->_config = $config;
        $this->_billTable = new Moto_Model_Table_JourneyBill();
        $this->_loadData();
    }

    public function getPositions()
    {
        return $this->_positions;
    }

    public function getValue()
    {
        $out = array(
            self::BILL_TYPE_CAR => 0,
            self::BILL_TYPE_PUBLIC => 0,
            'total' => 0
        );
        if (empty($this->_positions)) {
            return $out;
        }
        foreach ($this->_positions[self::BILL_TYPE_CAR] as $pos) {
            $out[self::BILL_TYPE_CAR] = $out[self::BILL_TYPE_CAR] + $pos['positionValue'];
        }
        foreach ($this->_positions[self::BILL_TYPE_PUBLIC] as $pos) {
            $out[self::BILL_TYPE_PUBLIC] = $out[self::BILL_TYPE_PUBLIC] + $pos['positionValue'];
        }
        $out['total'] = $out[self::BILL_TYPE_CAR] + $out[self::BILL_TYPE_PUBLIC];
        return $out;
    }

    private function _loadData()
    {
        $this->_positions = array(
            self::BILL_TYPE_CAR => array(),
            self::BILL_TYPE_PUBLIC => array()
        );
        $select = $this->_billTable->select()
            ->where('user_id = ?', $this->_userId);
        $positions = $this->_billTable->fetchAll($select)->toArray();
        if (empty($positions)) {
            return;
        }
        foreach ($positions as $pos) {
            if (self::BILL_TYPE_CAR == $pos['type']) {
                $distanceFactor = (900 <= (float) $pos['engine_capacity']) ? $this->_config['distanceFactor']['900plus'] : $this->_config['distanceFactor']['900'];
                $pos['positionValue'] = round(($pos['route_distance'] * $distanceFactor), 2);
                $pos['distanceFactor'] = $distanceFactor;
                $this->_positions[self::BILL_TYPE_CAR][] = $pos;
            }
            if (self::BILL_TYPE_PUBLIC == $pos['type']) {
                $pos['positionValue'] = round(($pos['ticket_price'] * $pos['transit_count']), 2);
                $this->_positions[self::BILL_TYPE_PUBLIC][] = $pos;
            }
        }
    }
}