<?php
class Moto_Model_Transit_BillInput
{
    private $_filtered;

    private $_raw;

    private $_status = true;

    private $_messages = array();

    public function __construct($data)
    {
        $this->_raw = $data;
        $this->_filter();
    }

    public function getFiltered()
    {
        return $this->_filtered;
    }

    public function validate()
    {
        $this->_status = true;
        $this->_messages = array();
        if (!isset($this->_filtered['departure_date']) || empty($this->_filtered['departure_date'])) {
            $this->_status = false;
            $this->_messages['departure_date'] = 'Podaj datę wyjazdu';
        }
        if (!isset($this->_filtered['route_description']) || empty($this->_filtered['route_description'])) {
            $this->_status = false;
            $this->_messages['route_description'] = 'Podaj opis trasy wyjazdu';
        }
        if (!isset($this->_filtered['departure_target']) || empty($this->_filtered['departure_target'])) {
            $this->_status = false;
            $this->_messages['departure_target'] = 'Podaj cel wyjazdu';
        }
        // Przejazd samochodem
        if (1 == $this->_filtered['car_option']) {
            if (!isset($this->_filtered['route_distance']) || empty($this->_filtered['route_distance'])) {
                $this->_status = false;
                $this->_messages['route_distance'] = 'Podaj liczbę kilometrów';
            }
            if (!isset($this->_filtered['register_number']) || empty($this->_filtered['register_number'])) {
                $this->_status = false;
                $this->_messages['register_number'] = 'Podaj numer rejestracyjny pojazdu';
            }
            if (!isset($this->_filtered['engine_capacity']) || empty($this->_filtered['engine_capacity'])) {
                $this->_status = false;
                $this->_messages['engine_capacity'] = 'Podaj pojemność silnika';
            }
        }
        // Przejazd komunikacją publiczną
        if (1 == $this->_filtered['public_option']) {
            if (!isset($this->_filtered['ticket_price']) || empty($this->_filtered['ticket_price'])) {
                $this->_status = false;
                $this->_messages['ticket_price'] = 'Podaj cenę biletu';
            }
            if (!isset($this->_filtered['transit_count']) || empty($this->_filtered['transit_count'])) {
                $this->_status = false;
                $this->_messages['transit_count'] = 'Podaj liczbę przejazdów';
            }
        }

        return array('status' => $this->_status, 'messages' => $this->_messages);
    }

    private function _filter()
    {
        $this->_filtered = array();
        foreach ($this->_raw as $key => $value) {
            $this->_filtered[$key] = trim(strip_tags($value));
        }
        $this->_filtered['route_distance'] = str_ireplace(',', '.', $this->_filtered['route_distance']);
        $this->_filtered['ticket_price'] = str_ireplace(',', '.', $this->_filtered['ticket_price']);
    }
}