<?php
class Forum_IndexController extends Moto_Model_Account_Controller
{
    private $_page;

    private $_pp;

    private $_flash;

    public function init()
    {
        $this->_page = (int) $this->_request->getParam('page', 1);
        $this->_pp = (int) $this->_request->getParam('pp', 10);
        $this->view->assign('page', $this->_page);
        $this->view->assign('pp', $this->_pp);
        $this->_flash = $this->_helper->getHelper('FlashMessenger');
    }

    public function indexAction()
    {
        if (empty($this->_account)) {
            $this->_redirect($this->_helper->url->url(array(
                'module' => 'forum',
                'controller' => 'index',
                'action' => 'info'
            )));
        }
        try {
            $manager = new Forum_Model_Manager();
            $allSubjects = $manager->getSubjects();
            $subjects = $manager->getSubjects(array('page' => $this->_page, 'pp' => $this->_pp));
            $this->view->assign('subjects', $subjects);
            $this->view->assign('subjectCount', count($subjects));
            $this->view->assign('isLogged', (!empty($this->_account)));
            $this->view->assign('addSubjectUrl', $this->_helper->url->url(array(
                'controller' => 'subject',
                'action' => 'add'
            )));
            $this->view->assign('flashMsgs', $this->_flash->getMessages());
            $this->view->assign('paginator', $this->_getPrevNextPages(count($allSubjects)));
        } catch (Exception $exc) {
            // echo $exc->getMessage();
        }
    }

    public function infoAction()
    {
        //
    }

    private function _getPrevNextPages($itemsCount)
    {
        if (1 < $this->_page) {
            $prev = $this->_page - 1;
        } else {
            $prev = 1;
        }
        $lastPageNumber = ceil($itemsCount / $this->_pp);
        if ($lastPageNumber > $this->_page) {
            $next = $this->_page + 1;
        } else {
            $next = $lastPageNumber;
        }
        return array('prev' => $prev, 'next' => $next, 'lastPage' => $lastPageNumber);
    }
}