<?php
class Forum_SubjectController extends Moto_Model_Account_Controller
{
    private $_page;

    private $_pp;

    private $_flash;

    public function init()
    {
        $this->_page = (int) $this->_request->getParam('page', 1);
        $this->_pp = (int) $this->_request->getParam('pp', 10);
        $this->view->assign('page', $this->_page);
        $this->view->assign('pp', $this->_pp);
        $this->_flash = $this->_helper->getHelper('FlashMessenger');
    }

    public function addAction()
    {
        $backUrl = $this->_helper->url->url(array(
            'module' => 'forum',
            'controller'=>'index',
            'action'=>'index'
        ));
        if (null === $this->_account) {
            $this->_redirect($backUrl);
        }
        if (!$this->_request->isPost()) {
            $this->_redirect($backUrl);
        }
        try {
            $manager = new Forum_Model_Manager();
            $formData = $this->_request->getPost('form');
            $filtered = array();
            foreach ($formData as $key => $value) {
                $filtered[$key] = trim(strip_tags($value));
            }
            if (!isset($filtered['content']) || empty($filtered['content'])) {
                $this->_flash->addMessage('Nie podano tematu');
                $this->_redirect($backUrl);
            }
            $manager->addSubject($filtered, $this->_account);
            $this->_flash->addMessage('Temat został dodany');
        } catch (Exception $exc) {
            $this->_flash->addMessage('Wystąpiły błędy podczas zapisu tematu');
        }
        $this->_redirect($backUrl);
    }

    public function showAction()
    {
        if (empty($this->_account)) {
            $this->_redirect($this->_helper->url->url(array(
                'module' => 'forum',
                'controller' => 'index',
                'action' => 'info'
            )));
        }
        try {
            $backUrl = $this->_helper->url->url(array(
                'module' => 'forum',
                'controller' => 'index',
                'action' => 'index',
                'page' => $this->_page,
                'pp' => $this->_pp
            ));
            $sid = (int) $this->_request->getParam('sid');
            if (empty($sid)) {
                $this->_redirect($backUrl);
            }
            $manager = new Forum_Model_Manager();
            $subject = $manager->getSubject($sid);
            if (empty($subject)) {
                $this->_redirect($backUrl);
            }
            $allEntries = $manager->getSubjectEntries($sid);
            $entries = $manager->getSubjectEntries($sid, array('page' => $this->_page, 'pp' => $this->_pp));

            $this->view->assign('entries', $entries);
            $this->view->assign('entryCount', count($entries));
            $this->view->assign('subject', $subject);
            $this->view->assign('backUrl', $backUrl);
            $this->view->assign('isLogged', (!empty($this->_account)));
            $this->view->assign('addEntryUrl', $this->_helper->url->url(array(
                'action' => 'add-entry',
                'sid' => $sid,
                'page' => $this->_page,
                'pp' => $this->_pp
            )));
            $this->view->assign('flashMsgs', $this->_flash->getMessages());
            $this->view->assign('paginator', $this->_getPrevNextPages(count($allEntries)));
        } catch (Exception $exc) {
            // $this->_flash->addMessage('Wystąpiły błędy podczas odczytu danych');
            $this->_flash->addMessage($exc->getMessage());
            $this->_redirect($this->_helper->url->url(array(
                'module' => 'forum',
                'controller'=>'index',
                'action'=>'index'
            )));
        }
    }

    public function addEntryAction()
    {
        $sid = (int) $this->_request->getParam('sid');
        $backUrl = $this->_helper->url->url(array(
            'action' => 'show',
            'sid' => $sid,
            'page' => $this->_page,
            'pp' => $this->_pp
        ));
        if (null === $this->_account) {
            $this->_redirect($backUrl);
        }
        if (!$this->_request->isPost()) {
            $this->_redirect($backUrl);
        }
        try {
            $formData = $this->_request->getPost('form');
            $filtered = array();
            foreach ($formData as $key => $value) {
                $filtered[$key] = trim(strip_tags($value));
            }
            if (!isset($filtered['content']) || empty($filtered['content'])) {
                $this->_flash->addMessage('Nie podano treści wpisu');
                $this->_redirect($backUrl);
            }
            $manager = new Forum_Model_Manager();
            $manager->addEntry($filtered, $sid, $this->_account);
            $this->_flash->addMessage('Wpis został dodany');
        } catch (Exception $exc) {
            $this->_flash->addMessage('Wystąpiły błędy podczas dodania wpisu');
        }
        $this->_redirect($backUrl);
    }

    private function _getPrevNextPages($itemsCount)
    {
        if (1 < $this->_page) {
            $prev = $this->_page - 1;
        } else {
            $prev = 1;
        }
        $lastPageNumber = ceil($itemsCount / $this->_pp);
        if ($lastPageNumber > $this->_page) {
            $next = $this->_page + 1;
        } else {
            $next = $lastPageNumber;
        }
        return array('prev' => $prev, 'next' => $next, 'lastPage' => $lastPageNumber);
    }
}