<?php
class Panel_AllocationController extends Zend_Controller_Action
{
    private $_facade;

    private $_page;

    private $_pp;

    private $_flash;

    private $_acl;

    public function init()
    {
        $this->_helper->layout()->setLayout('panel');
        $this->_facade = new Panel_Model_Facade();
        $this->_flash = $this->_helper->getHelper('FlashMessenger');
        $this->_page = (int) $this->_request->getParam('page', 1);
        $this->_pp = (int) $this->_request->getParam('pp', 10);
        $this->view->assign('page', $this->_page);
        $this->view->assign('pp', $this->_pp);
        $this->_acl = Zend_Registry::get('acl');
    }

    public function listUsersAction()
    {
        $paginationData = array(
            'page' => $this->_page,
            'count' => $this->_pp
        );
        $listData = $this->_facade->getUsersForAllocation($paginationData);
        $this->view->assign('listData', $listData);
        $this->view->assign('paginator', $this->_getPrevNextPages($listData['allCount']));
        $this->view->assign('flashMsgs', $this->_flash->getMessages());
        $this->view->assign('actionUrl', $this->_helper->url->url(array(
            'action' => 'assign-tutor',
            'page' => $this->_page,
            'pp' => $this->_pp
        )));
        $this->view->assign('pageLabel', 'Przydzielanie opiekunów');
    }

    public function assignTutorAction()
    {
        if (!$this->_request->isPost()) {
            $this->_flash->addMessage('Nieprawidłowa metoda przydzielenia opiekuna');
            $this->_redirect($this->_helper->url->url(array('action' => 'list-users')));
        }
        $user = Zend_Registry::get('panel-user');
        if (!$this->_acl->isAllowed($user['role'], 'assign-tutor')) {
            $this->_redirect($this->_helper->url->url(array('controller' => 'account', 'action' => 'forbidden', 'id' => null)));
        }
        $backUrl = $this->_helper->url->url(array(
            'action' => 'list-users',
            'page' => $this->_page,
            'pp' => $this->_pp
        ));
        $userId = (int) $this->_request->getPost('userId');
        $formId = (int) $this->_request->getPost('formId');
        $tutorId = (int) $this->_request->getPost('tutorId');
        if (0 < $tutorId) {
            // Przydzielenie opiekuna
            $response = $this->_facade->assignTutor($tutorId, $userId, $formId);
        } else {
            // Usunięcie opiekuna
            $response = $this->_facade->removeTutor($userId);
        }

        $this->_flash->addMessage($response['message']);
        $this->_redirect($backUrl);
    }

    private function _getPrevNextPages($itemsCount)
    {
        if (1 < $this->_page) {
            $prev = $this->_page - 1;
        } else {
            $prev = 1;
        }
        $lastPageNumber = ceil($itemsCount / $this->_pp);
        if ($lastPageNumber > $this->_page) {
            $next = $this->_page + 1;
        } else {
            $next = $lastPageNumber;
        }
        return array('prev' => $prev, 'next' => $next, 'lastPage' => $lastPageNumber);
    }
}