<?php
class Panel_ApplicationController extends Zend_Controller_Action
{
    private $_facceptData = array(
        0 => array(
            'label' => 'Wszystkie',
            'value' => 'all'
        ),
        1 => array(
            'label' => 'Oczekujące',
            'value' => Moto_Model_Table_RegisterForm::STATUS_NOT_VERIFIED
        ),
        2 => array(
            'label' => 'Zaakceptowane',
            'value' => Moto_Model_Table_RegisterForm::STATUS_ACCEPTED
        ),
        3 => array(
            'label' => 'Odrzucone',
            'value' => Moto_Model_Table_RegisterForm::STATUS_REJECTED
        )
    );

    private $_fAccept;

    private $_page;

    private $_pp;

    private $_urlQuery;

    private $_flash;

    private $_acl;

    public function init()
    {
        $this->_fAccept = (int) $this->_request->getParam('faccept');
        $this->_page = (int) $this->_request->getParam('page', 1);
        $this->_pp = (int) $this->_request->getParam('pp', 30);
        $this->view->assign('faccept', $this->_fAccept);
        $this->view->assign('facceptData', $this->_facceptData);
        $this->view->assign('page', $this->_page);
        $this->view->assign('pp', $this->_pp);
        $this->_buildUrlQuery();
        $this->view->assign('urlQuery', $this->_urlQuery);
        $this->_flash = $this->_helper->getHelper('FlashMessenger');
        $this->_helper->layout()->setLayout('panel-apps-filterable');
        $this->_acl = Zend_Registry::get('acl');
    }

    public function listAction()
    {
        try {
            $formsTable = new Moto_Model_Table_RegisterForm();
            $status = $this->_facceptData[$this->_fAccept]['value'];
            // Ilość wszystkich zgłoszeń z danym statusem
            $apps = $formsTable->getByStatus($status)->toArray();
            $allCount = count($apps);
            // Pobranie zgłoszeń z danym statusem z uwzględnieniem sortowania i paginacji
            $paginationData = array(
                'page' => $this->_page,
                'count' => $this->_pp
            );
            $apps = $formsTable->getByStatus($status, array('id desc'), $paginationData)->toArray();
            $this->view->assign('apps', $apps);
            $this->view->assign('allCount', $allCount);
            $this->view->assign('pageLabel', "Lista zgłoszeń uczestników (ilość: $allCount)");
            $this->view->assign('statusMap', array(
                'not_verified' => 'Oczekujące',
                'accepted' => 'Zaakceptowane',
                'rejected' => 'Odrzucone',
                'undefined' => 'Oczekujące'
            ));
            // Linki paginatora
            $this->view->assign('paginator', $this->_getPrevNextPages($allCount));
            $this->view->assign('flashMsgs', $this->_flash->getMessages());
        } catch (Exception $exc) {
            $this->view->assign('errorMsg', $exc->getMessage());
            $this->render('error');
            return;
        }
    }

    public function detailsAction()
    {
        $this->_helper->layout()->setLayout('panel');
        try {
            $id = (int) $this->_request->getParam('id');
            if (empty($id)) {
                throw new Exception('Niepoprawny identyfikator zgłoszenia');
            }
            $listUrl = $this->_helper->url->url(array(
                'action' => 'list',
                'page' => $this->_page,
                'pp' => $this->_pp,
                'id' => null
            )).$this->_urlQuery;
            $formsTable = new Moto_Model_Table_RegisterForm();
            $app = $formsTable->getById($id);
            if (null === $app) {
                $this->_flash->addMessage('Nie znaleziono zgłoszenia o podanym identyfikatorze');
                $this->_redirect($listUrl);
            }
            $appData = $app->toArray();
            $motoConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/moto.ini', APPLICATION_ENV);
            $schedule = new Moto_Model_Table_WorkshopSchedule();
            $preferredEvent = $schedule->getById($appData['preferred_date'])->toArray();
            $additionalEvent = $schedule->getById($appData['additional_date'])->toArray();
            $placeTypeMap = array('village' => 'wieś', 'city' => 'miasto');
            $appData['registered_place_type_name'] = (empty($appData['registered_place_type'])) ? null : $placeTypeMap[$appData['registered_place_type']];
            $appData['residence_place_type_name'] = (empty($appData['residence_place_type'])) ? null : $placeTypeMap[$appData['residence_place_type']];

            $this->view->assign('app', $appData);
            $this->view->assign('educationMap', $motoConfig->education->map->toArray());
            $this->view->assign('jobMap', $motoConfig->job->map->toArray());
            $this->view->assign('preferredEvent', $preferredEvent);
            $this->view->assign('additionalEvent', $additionalEvent);
            $this->view->assign('flashMsgs', $this->_flash->getMessages());
            $this->view->assign('pageLabel', 'Szczegóły zgłoszenia');
            $this->view->assign('actionUrl', $this->_helper->url->url(array(
                'action' => 'process-app',
                'page' => $this->_page,
                'pp' => $this->_pp,
                'id' => $appData['id']
            )).$this->_urlQuery);
            $this->view->assign('listUrl', $listUrl);
            $format = $this->_request->getParam('format');
            if ('csv' == $format) {
                $this->_helper->layout->disableLayout();
                $this->getHelper('viewRenderer')->setNoRender();
                $this->_response->setHeader('Content-type', 'text/csv');
                $this->_response->setHeader('Content-disposition', 'attachment;filename=dane_uzytkownika.csv');
                echo $this->_csvUserData($appData, array(
                    'educationMap' => $motoConfig->education->map->toArray(),
                    'jobMap' => $motoConfig->job->map->toArray(),
                    'preferredEvent' => $preferredEvent,
                    'additionalEvent' => $additionalEvent
                ));
            }
        } catch (Exception $exc) {
            $this->view->assign('errorMsg', $exc->getMessage());
            $this->render('error');
            return;
        }
    }

    public function processAppAction()
    {
        $listUrl = $this->_helper->url->url(array(
                'action' => 'list',
                'page' => $this->_page,
                'pp' => $this->_pp,
                'id' => null
            )).$this->_urlQuery;
        try {
            $user = Zend_Registry::get('panel-user');
            if (!$this->_acl->isAllowed($user['role'], 'process-app')) {
                $this->_redirect($this->_helper->url->url(array('controller' => 'account', 'action' => 'forbidden', 'id' => null)));
            }
            if (!$this->_request->isPost()) {
                throw new Exception('Niepoprawna metoda przetworzenia zgłoszenia');
            }
            $id = (int) $this->_request->getPost('id');
            $acceptValue = (int) $this->_request->getPost('acceptValue');
            $user = Zend_Registry::get('panel-user');
            switch ($acceptValue) {
                // Akceptacja
                case 1:
                    $msg = 'Zgłoszenie zostało zaakceptowane';
                    $ctrl = $this->_changeStatus($id, Moto_Model_Table_RegisterForm::STATUS_ACCEPTED, $user['id']);
                    break;
                // Odrzucenie
                case 2:
                    $msg = 'Zgłoszenie zostało odrzucone';
                    $ctrl = $this->_changeStatus($id, Moto_Model_Table_RegisterForm::STATUS_REJECTED, $user['id']);
                    break;
                default:
                    throw new Exception('Nieznana opcja przetworzenia zgłoszenia');
            }

            $this->_flash->addMessage($msg);
        } catch (Exception $exc) {
            $this->_flash->addMessage('Pojawiły się błędy podczas przetwarzania zgłoszenia');
            $this->_redirect($this->_helper->url->url(array(
                'action' => 'details',
                'page' => $this->_page,
                'pp' => $this->_pp,
                'id' => $id
            )).$this->_urlQuery);
        }
        $this->_redirect($listUrl);
    }

    private function _buildUrlQuery()
    {
        $data = array(
            'faccept' => $this->_fAccept
        );
        $this->_urlQuery = '?'.http_build_query($data);
    }

    private function _getPrevNextPages($itemsCount)
    {
        if (1 < $this->_page) {
            $prev = $this->_page - 1;
        } else {
            $prev = 1;
        }
        $lastPageNumber = ceil($itemsCount / $this->_pp);
        if ($lastPageNumber > $this->_page) {
            $next = $this->_page + 1;
        } else {
            $next = $lastPageNumber;
        }
        return array('prev' => $prev, 'next' => $next, 'lastPage' => $lastPageNumber);
    }

    private function _changeStatus($id, $status, $userId)
    {
        $formsTable = new Moto_Model_Table_RegisterForm();
        $app = $formsTable->getById($id);
        if (null === $app) {
            throw new Exception('Nie znaleziono zgłoszenia o podanym identyfikatorze');
        }
        $app->status = $status;
        $app->status_change_date = date('Y-m-d H:i:s');
        $app->status_change_by = $userId;
        return $app->save();
    }

    private function _csvUserData($baseData, $otherData)
    {
        $delimiter = ';';
        $lines = array();
        $statusMap = array(
            Moto_Model_Table_RegisterForm::STATUS_NOT_VERIFIED => 'Oczekujące',
            Moto_Model_Table_RegisterForm::STATUS_ACCEPTED => 'Zaakceptowane',
            Moto_Model_Table_RegisterForm::STATUS_REJECTED => 'Odrzucone'
        );
        $lines[] = 'Status zgłoszenia'.$delimiter.$statusMap[$baseData['status']];
        $lines[] = 'Dane ogólne';
        $lines[] = 'Imię'.$delimiter.$baseData['first_name'];
        $lines[] = 'Drugie imię'.$delimiter.$baseData['second_name'];
        $lines[] = 'Nazwisko'.$delimiter.$baseData['last_name'];
        $lines[] = 'Płeć'.$delimiter.(('female' == $baseData['gender']) ? 'kobieta' : 'mężczyzna');
        $lines[] = 'Data urodzenia'.$delimiter.$baseData['birth_date'];
        $lines[] = 'Miejsce urodzenia'.$delimiter.$baseData['birth_place'];
        $lines[] = 'Wiek w latach'.$delimiter.$baseData['age'];
        $lines[] = 'Opieka nad dziećmi do lat 7 lub nad osobą zależną'.$delimiter.((1 == $baseData['care']) ? 'Tak' : 'Nie');
        $lines[] = 'PESEL'.$delimiter.$baseData['pesel'];
        $lines[] = 'Jestem osobą niepełnosprawną'.$delimiter.((1 == $baseData['disability']) ? 'Tak' : 'Nie');
        $lines[] = 'Adres zameldowania';
        $lines[] = 'Ulica'.$delimiter.$baseData['registered_street'];
        $lines[] = 'Numer domu'.$delimiter.$baseData['registered_house_number'];
        $lines[] = 'Numer lokalu'.$delimiter.$baseData['registered_local_number'];
        $lines[] = 'Miejscowość'.$delimiter.$baseData['registered_place'].' ('.$baseData['registered_place_type_name'].')';
        $lines[] = 'Kod pocztowy'.$delimiter.$baseData['registered_postal_code'];
        $lines[] = 'Poczta'.$delimiter.$baseData['registered_post'];
        $lines[] = 'Gmina'.$delimiter.$baseData['registered_region'];
        $lines[] = 'Powiat'.$delimiter.$baseData['registered_district'];
        $lines[] = 'Województwo'.$delimiter.$baseData['registered_province'];
        $lines[] = 'Kontakt';
        $lines[] = 'Numer telefonu'.$delimiter.$baseData['phone'];
        $lines[] = 'Telefon komórkowy'.$delimiter.$baseData['cell_phone'];
        $lines[] = 'Email'.$delimiter.$baseData['email'];
        $lines[] = 'Fax'.$delimiter.$baseData['fax'];
        $lines[] = 'Adres zamieszkania';
        $lines[] = 'Ulica'.$delimiter.$baseData['residence_street'];
        $lines[] = 'Numer domu'.$delimiter.$baseData['residence_house_number'];
        $lines[] = 'Numer lokalu'.$delimiter.$baseData['residence_local_number'];
        $residencePlace = (!empty($baseData['residence_place'])) ? $baseData['residence_place'].' ('.$baseData['registered_place_type_name'].')' : '';
        $lines[] = 'Miejscowość'.$delimiter.$residencePlace;
        $lines[] = 'Kod pocztowy'.$delimiter.$baseData['residence_postal_code'];
        $lines[] = 'Poczta'.$delimiter.$baseData['residence_post'];
        $lines[] = 'Gmina'.$delimiter.$baseData['residence_region'];
        $lines[] = 'Powiat'.$delimiter.$baseData['residence_district'];
        $lines[] = 'Województwo'.$delimiter.$baseData['residence_province'];
        $lines[] = 'Wykształcenie'.$delimiter.$otherData['educationMap'][$baseData['education']];
        $lines[] = 'Wykształcenie - dane dotyczące zatrudnienia';
        $lines[] = 'Nazwa zakładu pracy'.$delimiter.$baseData['workplace'];
        $lines[] = 'Zajmowane stanowisko/wykonywany zawód';
        if (1 == $baseData['teacher']) {
            $lines[] = ' '.$delimiter.'nauczyciel przedmiotów zawodowych';
        }
        if (1 == $baseData['instructor']) {
            $lines[] = ' '.$delimiter.'instruktor praktycznej nauki zawodu';
        }
        foreach ($otherData['jobMap'] as $key => $title) {
            if (1 == $baseData[$key]) {
                $lines[] = ' '.$delimiter.$title;
            }
        }
        $lines[] = 'Posiadane udokumentowane kwalifikacje zawodowe'.$delimiter.$baseData['qualifications'];
        $lines[] = 'Doświadczenie zawodowe (staż pracy)'.$delimiter.$baseData['experience'];
        $lines[] = 'Kryteria merytoryczne kwalifikacji do projektu';
        $lines[] = 'Oświadczam, iż jestem osobą powyżej 45 roku życia'.$delimiter.((1 == $baseData['age45plus']) ? 'Tak' : 'Nie');
        $lines[] = 'Oświadczam, iż w przeciągu ostatnich 3 lat nie uczestniczyłem/am w praktykach w przedsiębiorstwie'.$delimiter.((1 == $baseData['none_practice']) ? 'Tak' : 'Nie');
        $lines[] = 'Suma punktów'.$delimiter.$baseData['points'];
        $lines[] = 'Data rozpoczęcia udziału w projekcie - termin preferowany';
        $lines[] = 'Data wybranego cyklu praktyk'.$delimiter.$otherData['preferredEvent']['practice_start_date'].$delimiter.$otherData['preferredEvent']['practice_stop_date'];
        $lines[] = 'Data wybranego cyklu warsztatów przygotowawczych'.$delimiter.$otherData['preferredEvent']['prepare_start_date'].$delimiter.$otherData['preferredEvent']['prepare_stop_date'];
        $lines[] = 'Data rozpoczęcia udziału w projekcie - termin dodatkowy';
        $lines[] = 'Data wybranego cyklu praktyk'.$delimiter.$otherData['additionalEvent']['practice_start_date'].$delimiter.$otherData['additionalEvent']['practice_stop_date'];
        $lines[] = 'Data wybranego cyklu warsztatów przygotowawczych'.$delimiter.$otherData['additionalEvent']['prepare_start_date'].$delimiter.$otherData['additionalEvent']['prepare_stop_date'];

        $txt = implode(PHP_EOL, $lines);
        return $txt;
    }
}