<?php

class Panel_AuthController extends Zend_Controller_Action
{
    public function init()
    {
        $this->_helper->layout()->setLayout('panel-login');
    }

    /**
     * Formularz logowania i mechanizm logowania do panelu
     */
    public function loginAction()
    {
        $this->view->assign('actionUrl', $this->_helper->url->url(array()));
        $flash = $this->_helper->getHelper('FlashMessenger');
        $this->view->assign('messages', $flash->getMessages());
        // Przetworzenie formularza
        if ($this->_request->isPost()) {
            $formData = $this->_request->getPost('form');
            $login = trim(strip_tags($formData['login']));
            $password = trim(strip_tags($formData['pswd']));
            if (empty($login) || empty($password)) {
                $flash->addMessage('Nieprawidłowa nazwa użytkownika lub hasło');
                $this->_redirect($this->_helper->url->url(array()));
            }
            $usersTable = new Moto_Model_Table_Users();
            $authAdapter = new Zend_Auth_Adapter_DbTable($usersTable->getAdapter());
            $authAdapter->setTableName($usersTable->info('name'))
                ->setIdentityColumn('email')
                ->setCredentialColumn('password_hash');
            $authAdapter->setIdentity($login)->setCredential(sha1($password));
            $result = Zend_Auth::getInstance()->authenticate($authAdapter);
            if (!$result->isValid()) {
                $flash->addMessage('Nieprawidłowa nazwa użytkownika lub hasło');
                $this->_redirect($this->_helper->url->url(array()));
            }
            $panelRoles = Zend_Registry::get('panel-roles');
            $identity = Zend_Auth::getInstance()->getIdentity();
            $user = $usersTable->getByEmail($identity)->toArray();
            if (!in_array($user['role'], $panelRoles)) {
                $flash->addMessage('Nieprawidłowa nazwa użytkownika lub hasło');
                $this->_redirect($this->_helper->url->url(array('action'=>'logout')));
            }
            $this->_redirect('/panel');
        }
    }

    /**
     * Wylogowanie z panelu
     */
    public function logoutAction()
    {
        Zend_Auth::getInstance()->clearIdentity();
        $this->_redirect('/panel/login');
    }
}