<?php
class Panel_BillController extends Zend_Controller_Action
{
    private $_facade;

    public function init()
    {
        $this->_helper->layout()->setLayout('panel');
        $this->_facade = new Panel_Model_Facade();
    }

    public function indexAction()
    {
        try {
            $bills = $this->_facade->getBills();
            $config = new Zend_Config_Ini(APPLICATION_PATH.'/configs/moto.ini', APPLICATION_ENV);

            $this->view->assign('bills', $bills);
            $this->view->assign('places', $config->practicePlace->toArray());
            $this->view->assign('billPerUser', $config->billPerUser);
            $this->view->assign('pageLabel', 'Rozliczenia');
        } catch (Exception $exc) {
            echo $exc->getMessage();
        }
    }

    public function tutorAction()
    {
        try {
            $bills = $this->_facade->getTutorBills();

            $this->view->assign('tutorBills', $bills);
            $this->view->assign('pageLabel', 'Rozliczenia opiekunów');
        } catch (Exception $exc) {
            echo $exc->getMessage();
        }
    }
}