<?php
class Panel_DocController extends Zend_Controller_Action
{
    private $_facade;

    private $_flash;

    private $_page;

    private $_pp;

    private $_acl;


    public function init()
    {
        $this->_helper->layout()->setLayout('panel');
        $this->_facade = new Panel_Model_Facade();
        $this->_flash = $this->_helper->getHelper('FlashMessenger');
        $this->_page = (int) $this->_request->getParam('page', 1);
        $this->_pp = (int) $this->_request->getParam('pp', 20);
        $this->view->assign('page', $this->_page);
        $this->view->assign('pp', $this->_pp);
        $this->_acl = Zend_Registry::get('acl');
    }

    public function presenceListsAction()
    {
        $motoConfig = new Zend_Config_Ini(APPLICATION_PATH.'/configs/moto.ini', APPLICATION_ENV);
        $this->view->assign('practicePlace', $motoConfig->practicePlace->toArray());
        $this->view->assign('pageLabel', 'Listy obecności');
        $this->view->assign('flashMsgs', $this->_flash->getMessages());
    }

    public function presenceAction()
    {
        $this->_helper->layout->disableLayout();
        $this->getHelper('viewRenderer')->setNoRender();
        $this->_response->setHeader('Content-type', 'application/pdf');
        $pid = (int) $this->_request->getParam('id');
        try {
            $listInfo = $this->_facade->getPresenceList($pid);

            $view = new Zend_View();
            $view->setScriptPath(APPLICATION_PATH.'/modules/panel/views/scripts/doc/');
            $view->assign('domain', 'http://'.$this->_request->getServer('HTTP_HOST'));
            $view->assign('info', $listInfo);
            $html = $view->render('presence.phtml');
            require_once("dompdf/dompdf_config.inc.php");
            $dompdf = new DOMPDF();
            $dompdf->load_html($html, 'utf-8');
            $dompdf->render();
            echo $dompdf->output();
        } catch (Exception $exc) {
            $this->_flash->addMessage($exc->getMessage());
            $this->_redirect($this->_helper->url->url(array('action'=>'presence-lists')));
        }
    }

    public function certificateListAction()
    {
        try {
            $this->view->assign('pageLabel', 'Zaświadczenia i certyfikaty');
            $allLogs = $this->_facade->getCertificateList();
            $allCount = count($allLogs);
            $paginationData = array(
                'page' => $this->_page,
                'count' => $this->_pp
            );
            $logs = $this->_facade->getCertificateList('all', $paginationData);
            $this->view->assign('logs', $logs);
            $this->view->assign('allCount', $allCount);
            $this->view->assign('flashMsgs', $this->_flash->getMessages());
            $this->view->assign('paginator', $this->_getPrevNextPages($allCount));
            $this->view->assign('actionUrl', $this->_helper->url->url(array(
                'action' => 'cert-access-change',
                'page' => $this->_page,
                'pp' => $this->_pp
            )));
        } catch (Exception $exc) {
            echo $exc->getMessage();
        }
    }

    public function certAccessChangeAction()
    {
        try {
            $user = Zend_Registry::get('panel-user');
            if (!$this->_acl->isAllowed($user['role'], 'cert-access-change')) {
                $this->_redirect($this->_helper->url->url(array('controller' => 'account', 'action' => 'forbidden', 'id' => null)));
            }
            $backUrl = $this->_helper->url->url(array(
                'action' => 'certificate-list',
                'page' => $this->_page,
                'pp' => $this->_pp
            ));
            if (!$this->_request->isPost()) {
                $this->_flash->addMessage('Nieprawidłowa metoda zmiany dostępu do certyfikatu');
                $this->_redirect($backUrl);
            }
            $postData = $this->_request->getPost('form');
            $filtered = array();
            foreach ($postData as $key => $value) {
                $filtered[$key] = (int) $value;
            }
            $response = $this->_facade->changeCertificateAccess($filtered);
            $this->_flash->addMessage($response['message']);
            $this->_redirect($backUrl);
        } catch (Exception $exc) {
            $this->_flash->addMessage('Wystąpił błąd: '.$exc->getMessage());
            $this->_redirect($backUrl);
        }
    }

    private function _getPrevNextPages($itemsCount)
    {
        if (1 < $this->_page) {
            $prev = $this->_page - 1;
        } else {
            $prev = 1;
        }
        $lastPageNumber = ceil($itemsCount / $this->_pp);
        if ($lastPageNumber > $this->_page) {
            $next = $this->_page + 1;
        } else {
            $next = $lastPageNumber;
        }
        return array('prev' => $prev, 'next' => $next, 'lastPage' => $lastPageNumber);
    }
}