<?php
class Panel_StatsController extends Zend_Controller_Action
{
    public function init()
    {
        $this->_helper->layout()->setLayout('panel');
    }

    public function pollAction()
    {
        try {
            $quests = array();
            $keys = array();

            $quests['practiceBefore'] = Moto_Model_Poll_Manager::getRatedQuestions(Moto_Model_Poll_Manager::ID_PRACTICE_BEFORE);
            $keys['practiceBefore'] = array_keys($quests['practiceBefore']);
            $quests['prepareBefore'] = Moto_Model_Poll_Manager::getRatedQuestions(Moto_Model_Poll_Manager::ID_PREPARE_BEFORE);
            $keys['prepareBefore'] = array_keys($quests['prepareBefore']);
            $quests['practiceAfter'] = Moto_Model_Poll_Manager::getRatedQuestions(Moto_Model_Poll_Manager::ID_PRACTICE_AFTER);
            $keys['practiceAfter'] = array_keys($quests['practiceAfter']);
            $quests['prepareAfter'] = Moto_Model_Poll_Manager::getRatedQuestions(Moto_Model_Poll_Manager::ID_PREPARE_AFTER);
            $keys['prepareAfter'] = array_keys($quests['prepareAfter']);

            $answers = array();
            $answersTable = new Moto_Model_Table_PollAnswer();
            $answers['practiceBefore'] = $answersTable->getAnswersByPoll(Moto_Model_Poll_Manager::ID_PRACTICE_BEFORE, $keys['practiceBefore']);
            $answers['practiceAfter'] = $answersTable->getAnswersByPoll(Moto_Model_Poll_Manager::ID_PRACTICE_AFTER, $keys['practiceAfter']);
            $answers['prepareBefore'] = $answersTable->getAnswersByPoll(Moto_Model_Poll_Manager::ID_PREPARE_BEFORE, $keys['prepareBefore']);
            $answers['prepareAfter'] = $answersTable->getAnswersByPoll(Moto_Model_Poll_Manager::ID_PREPARE_AFTER, $keys['prepareAfter']);

            $this->_addStats($quests['practiceBefore'], $answers['practiceBefore']);
            $this->_addStats($quests['practiceAfter'], $answers['practiceAfter']);
            $this->_addStats($quests['prepareBefore'], $answers['prepareBefore']);
            $this->_addStats($quests['prepareAfter'], $answers['prepareAfter']);

            $this->view->assign('quests', $quests);
            $this->view->assign('csvUrl', $this->_helper->url->url(array('format'=>'csv')));
            $this->view->assign('pageLabel', 'Statystyki ewaluacji');
            $format = $this->_request->getParam('format');
            if ('csv' == $format) {
                $this->_helper->layout->disableLayout();
                $this->getHelper('viewRenderer')->setNoRender();
                $this->_response->setHeader('Content-type', 'text/csv');
                $this->_response->setHeader('Content-disposition', 'attachment;filename=statystyki-ewaluacje.csv');
                echo $this->_formatEvaluationCsv($quests);
            }
        } catch (Exception $exc) {
            echo $exc->getMessage();
        }
    }

    public function attachmentAction()
    {
        try {
            $quests = array();
            $keys = array();

            $quests['diagnostic'] = Moto_Model_Poll_Manager::getAttachmentRatedQuestions(Moto_Model_Poll_Manager::ID_ATTACHMENT_DIAGNOSTIC);
            $keys['diagnostic'] = $this->_getAttachmentIds($quests['diagnostic']);
            $quests['electro'] = Moto_Model_Poll_Manager::getAttachmentRatedQuestions(Moto_Model_Poll_Manager::ID_ATTACHMENT_ELECTRO);
            $keys['electro'] = $this->_getAttachmentIds($quests['electro']);
            $quests['repair'] = Moto_Model_Poll_Manager::getAttachmentRatedQuestions(Moto_Model_Poll_Manager::ID_ATTACHMENT_REPAIR);
            $keys['repair'] = $this->_getAttachmentIds($quests['repair']);
            $quests['thinsmith'] = Moto_Model_Poll_Manager::getAttachmentRatedQuestions(Moto_Model_Poll_Manager::ID_ATTACHMENT_THINSMITH);
            $keys['thinsmith'] = $this->_getAttachmentIds($quests['thinsmith']);

            $answers = array();
            $answersTable = new Moto_Model_Table_AttachmentData();
            $answers['diagnostic'] = $answersTable->getAnswersByAttachment(Moto_Model_Poll_Manager::ID_ATTACHMENT_DIAGNOSTIC, $keys['diagnostic']);
            $answers['electro'] = $answersTable->getAnswersByAttachment(Moto_Model_Poll_Manager::ID_ATTACHMENT_ELECTRO, $keys['electro']);
            $answers['repair'] = $answersTable->getAnswersByAttachment(Moto_Model_Poll_Manager::ID_ATTACHMENT_REPAIR, $keys['repair']);
            $answers['thinsmith'] = $answersTable->getAnswersByAttachment(Moto_Model_Poll_Manager::ID_ATTACHMENT_THINSMITH, $keys['thinsmith']);

            $this->_addAttachmentStats($quests['electro']['questions'], $answers['electro']);
            $this->_addAttachmentStats($quests['diagnostic']['questions'], $answers['diagnostic']);
            $this->_addAttachmentStats($quests['repair']['questions'], $answers['repair']);
            $this->_addAttachmentStats($quests['thinsmith']['questions'], $answers['thinsmith']);

            $this->view->assign('quests', $quests);
            $this->view->assign('pageLabel', 'Statystyki załączników');
            $this->view->assign('csvUrl', $this->_helper->url->url(array('format'=>'csv')));
            $format = $this->_request->getParam('format');
            if ('csv' == $format) {
                $this->_helper->layout->disableLayout();
                $this->getHelper('viewRenderer')->setNoRender();
                $this->_response->setHeader('Content-type', 'text/csv');
                $this->_response->setHeader('Content-disposition', 'attachment;filename=statystyki-zalaczniki.csv');
                echo $this->_formatAttachmentCsv($quests);
            }
        } catch (Exception $exc) {
            echo $exc->getMessage();
        }
    }

    private function _addStats(&$quests, $answers)
    {
        foreach ($answers as $answer) {
            if (!isset($quests[$answer['question_id']]['answers'][$answer['answer_id']]['count'])) {
                $quests[$answer['question_id']]['answers'][$answer['answer_id']]['count'] = 1;
            } else {
                $quests[$answer['question_id']]['answers'][$answer['answer_id']]['count']++;
            }
        }
    }

    private function _getAttachmentIds($data)
    {
        $ids = array();
        foreach ($data['questions'] as $item) {
            foreach ($item['data'] as $key => $value) {
                $ids[] = $key;
            }
        }
        return $ids;
    }

    private function _addAttachmentStats(&$quests, $answers)
    {
        $formattedAnswers = array();
        foreach ($answers as $answer) {
            if (!isset($formattedAnswers[$answer['question_id']][$answer['content']])) {
                $formattedAnswers[$answer['question_id']][$answer['content']] = 1;
            } else {
                $formattedAnswers[$answer['question_id']][$answer['content']]++;
            }
        }
        foreach ($quests as &$item) {
            foreach ($item['data'] as $qId => &$qData) {
                foreach ($qData['answers'] as $aId => &$ansData) {
                    if (isset($formattedAnswers[$qId][$aId])) {
                        $ansData['count'] = $formattedAnswers[$qId][$aId];
                    }
                }
                unset($ansData);
            }
            unset($qData);
        }
        unset($item);
    }

    private function _formatEvaluationCsv($quests)
    {
        $delimiter = ';';
        $lines = array();
        $docs = array(
            'practiceBefore' => 'Przed rozpoczęciem praktyk',
            'practiceAfter' => 'Po zakończeniu praktyk',
            'prepareBefore' => 'Przed rozpoczęciem warsztatów',
            'prepareAfter' => 'Po zakończeniu warsztatów'
        );
        foreach ($docs as $docType => $label) {
            $lines[] = $label.$delimiter.'';
            foreach ($quests[$docType] as $quest) {
                $lines[] = $quest['content'].$delimiter;
                $lines[] = 'Odpowiedzi'.$delimiter.'Ilość';
                foreach ($quest['answers'] as $answer) {
                    $line = $answer['label'].$delimiter;
                    $amount = (isset($answer['count'])) ? $answer['count'] : 0;
                    $line = $line.$amount;
                    $lines[] = $line;
                }
            }
        }

        $txt = implode(PHP_EOL, $lines);
        return $txt;
    }

    private function _formatAttachmentCsv($quests)
    {
        $delimiter = ';';
        $lines = array();
        foreach ($quests as $quest) {
            $lines[] = $quest['title'];
            foreach ($quest['questions'] as $question) {
                $lines[] = $question['content'];
                $counter = 0;
                foreach ($question['data'] as $subQuest) {
                    $label = (0 == $counter) ? 'przed' : 'po';
                    $lines[] = 'Odpowiedź'.$delimiter.'Ilość '.$label;
                    foreach ($subQuest['answers'] as $answer) {
                        $amount = (isset($answer['count'])) ? $answer['count'] : 0;
                        $lines[] = $answer['label'].$delimiter.$amount;
                    }
                    $counter++;
                }
            }
        }
        $txt = implode(PHP_EOL, $lines);
        return $txt;
    }
}