<?php
class Panel_Model_Controller_Plugin_Auth extends Zend_Controller_Plugin_Abstract
{
    public function preDispatch(Zend_Controller_Request_Abstract $request)
    {
        if ('panel' != $request->getModuleName()) {
            return;
        }
        $auth = Zend_Auth::getInstance();
        $identity = $auth->getIdentity();
        $redirector = Zend_Controller_Action_HelperBroker::getStaticHelper('redirector');
        // Użytkownik nie jest zalogowany
        if (empty($identity)) {
            // Ekran logowania
            if ('auth' == $request->getControllerName() && 'login' == $request->getActionName()) {
                return;
            }
            $redirector->gotoUrl('/panel/auth/login');
        }
        // Użytkownik zalogowany
        else {
            // Wywołanie formularza logowania
            if ('auth' == $request->getControllerName() && 'login' == $request->getActionName()) {
                $redirector->gotoUrl('/panel');
            }
            $panelRoles = Zend_Registry::get('panel-roles');
            $usersTable = new Moto_Model_Table_Users();
            $user = $usersTable->getByEmail($identity)->toArray();
            if (!in_array($user['role'], $panelRoles)) {
                $redirector->gotoUrl('/');
            }
        }
    }
}