$(document).ready(function() {
    var birthDate = $('#birthDate');
    var formDate = $('#formDate');
    var billDepartureDate = $('#departureDate');
    
    birthDate.datepicker({
        altFormat: 'yy-mm-dd',
        dateFormat: 'yy-mm-dd',
        changeYear: true,
        yearRange: '1900:2015'
    });
    formDate.datepicker({
        altFormat: 'yy-mm-dd',
        dateFormat: 'yy-mm-dd',
        changeYear: true,
        yearRange: '2000:2015'
    });
    billDepartureDate.datepicker({
        altFormat: 'yy-mm-dd',
        dateFormat: 'yy-mm-dd',
        changeYear: true,
        yearRange: '2014:2015'
    });

    birthDate.on('change', function() {
        var bDate = birthDate.val();
        if ('' == bDate) {
            return;
        };
        var bDateParts = bDate.split('-');
        var bYear = parseInt(bDateParts[0]);
        var nowDate = new Date();
        var nowYear = nowDate.getFullYear();
        var age = nowYear - bYear;
        $('#age').val(age);
    });
})