/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.LambdaFormBuffer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import sun.invoke.util.Wrapper;

class LambdaFormEditor {
    final LambdaForm lambdaForm;
    private static final int MIN_CACHE_ARRAY_SIZE = 4;
    private static final int MAX_CACHE_ARRAY_SIZE = 16;

    private LambdaFormEditor(LambdaForm lambdaForm) {
        this.lambdaForm = lambdaForm;
    }

    static LambdaFormEditor lambdaFormEditor(LambdaForm lambdaForm) {
        return new LambdaFormEditor(lambdaForm.uncustomize());
    }

    private LambdaForm getInCache(Transform transform) {
        Transform transform2;
        block5: {
            Transform transform3;
            Object object;
            block6: {
                block4: {
                    assert (transform.get() == null);
                    object = this.lambdaForm.transformCache;
                    transform2 = null;
                    if (!(object instanceof ConcurrentHashMap)) break block4;
                    ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)object;
                    transform2 = (Transform)concurrentHashMap.get(transform);
                    break block5;
                }
                if (object == null) {
                    return null;
                }
                if (!(object instanceof Transform)) break block6;
                Transform transform4 = (Transform)object;
                if (!transform4.equals(transform)) break block5;
                transform2 = transform4;
                break block5;
            }
            Transform[] transformArray = (Transform[])object;
            for (int i = 0; i < transformArray.length && (transform3 = transformArray[i]) != null; ++i) {
                if (!transform3.equals(transform)) continue;
                transform2 = transform3;
                break;
            }
        }
        assert (transform2 == null || transform.equals(transform2));
        return transform2 != null ? (LambdaForm)transform2.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LambdaForm putInCache(Transform transform, LambdaForm lambdaForm) {
        transform = transform.withResult(lambdaForm);
        int n = 0;
        while (true) {
            block23: {
                Object object;
                Transform[] transformArray;
                Object object2;
                Object object3;
                if ((object3 = this.lambdaForm.transformCache) instanceof ConcurrentHashMap) {
                    object2 = (ConcurrentHashMap)object3;
                    transformArray = ((ConcurrentHashMap)object2).putIfAbsent(transform, transform);
                    if (transformArray == null) {
                        return lambdaForm;
                    }
                    object = (LambdaForm)transformArray.get();
                    if (object != null) {
                        return object;
                    }
                    if (((ConcurrentHashMap)object2).replace(transform, transformArray, transform)) {
                        return lambdaForm;
                    }
                } else {
                    assert (n == 0);
                    object2 = this.lambdaForm;
                    synchronized (object2) {
                        Object object4;
                        int n2;
                        object3 = this.lambdaForm.transformCache;
                        if (object3 instanceof ConcurrentHashMap) {
                            break block23;
                        }
                        if (object3 == null) {
                            this.lambdaForm.transformCache = transform;
                            return lambdaForm;
                        }
                        if (object3 instanceof Transform) {
                            object = (Transform)object3;
                            if (((Transform)object).equals(transform)) {
                                LambdaForm lambdaForm2 = (LambdaForm)((SoftReference)object).get();
                                if (lambdaForm2 == null) {
                                    this.lambdaForm.transformCache = transform;
                                    return lambdaForm;
                                }
                                return lambdaForm2;
                            }
                            if (((SoftReference)object).get() == null) {
                                this.lambdaForm.transformCache = transform;
                                return lambdaForm;
                            }
                            transformArray = new Transform[4];
                            transformArray[0] = object;
                            this.lambdaForm.transformCache = transformArray;
                        } else {
                            transformArray = (Transform[])object3;
                        }
                        int n3 = transformArray.length;
                        int n4 = -1;
                        for (n2 = 0; n2 < n3 && (object4 = transformArray[n2]) != null; ++n2) {
                            if (((Transform)object4).equals(transform)) {
                                Transform[] transformArray2 = (Transform[])((SoftReference)object4).get();
                                if (transformArray2 == null) {
                                    transformArray[n2] = transform;
                                    return lambdaForm;
                                }
                                return transformArray2;
                            }
                            if (n4 >= 0 || ((SoftReference)object4).get() != null) continue;
                            n4 = n2;
                        }
                        if (n2 >= n3 && n4 < 0) {
                            if (n3 >= 16) {
                                object4 = new ConcurrentHashMap(32);
                                for (Transform transform2 : transformArray) {
                                    ((ConcurrentHashMap)object4).put(transform2, transform2);
                                }
                                this.lambdaForm.transformCache = object4;
                                break block23;
                            }
                            n3 = Math.min(n3 * 2, 16);
                            this.lambdaForm.transformCache = transformArray = Arrays.copyOf(transformArray, n3);
                        }
                        int n5 = n4 >= 0 ? n4 : n2;
                        transformArray[n5] = transform;
                        return lambdaForm;
                    }
                }
            }
            ++n;
        }
    }

    private LambdaFormBuffer buffer() {
        return new LambdaFormBuffer(this.lambdaForm);
    }

    private BoundMethodHandle.SpeciesData oldSpeciesData() {
        return BoundMethodHandle.speciesData(this.lambdaForm);
    }

    private BoundMethodHandle.SpeciesData newSpeciesData(LambdaForm.BasicType basicType) {
        return this.oldSpeciesData().extendWith(basicType);
    }

    BoundMethodHandle bindArgumentL(BoundMethodHandle boundMethodHandle, int n, Object object) {
        assert (boundMethodHandle.speciesData() == this.oldSpeciesData());
        LambdaForm.BasicType basicType = LambdaForm.BasicType.L_TYPE;
        MethodType methodType = this.bindArgumentType(boundMethodHandle, n, basicType);
        LambdaForm lambdaForm = this.bindArgumentForm(1 + n);
        return boundMethodHandle.copyWithExtendL(methodType, lambdaForm, object);
    }

    BoundMethodHandle bindArgumentI(BoundMethodHandle boundMethodHandle, int n, int n2) {
        assert (boundMethodHandle.speciesData() == this.oldSpeciesData());
        LambdaForm.BasicType basicType = LambdaForm.BasicType.I_TYPE;
        MethodType methodType = this.bindArgumentType(boundMethodHandle, n, basicType);
        LambdaForm lambdaForm = this.bindArgumentForm(1 + n);
        return boundMethodHandle.copyWithExtendI(methodType, lambdaForm, n2);
    }

    BoundMethodHandle bindArgumentJ(BoundMethodHandle boundMethodHandle, int n, long l) {
        assert (boundMethodHandle.speciesData() == this.oldSpeciesData());
        LambdaForm.BasicType basicType = LambdaForm.BasicType.J_TYPE;
        MethodType methodType = this.bindArgumentType(boundMethodHandle, n, basicType);
        LambdaForm lambdaForm = this.bindArgumentForm(1 + n);
        return boundMethodHandle.copyWithExtendJ(methodType, lambdaForm, l);
    }

    BoundMethodHandle bindArgumentF(BoundMethodHandle boundMethodHandle, int n, float f) {
        assert (boundMethodHandle.speciesData() == this.oldSpeciesData());
        LambdaForm.BasicType basicType = LambdaForm.BasicType.F_TYPE;
        MethodType methodType = this.bindArgumentType(boundMethodHandle, n, basicType);
        LambdaForm lambdaForm = this.bindArgumentForm(1 + n);
        return boundMethodHandle.copyWithExtendF(methodType, lambdaForm, f);
    }

    BoundMethodHandle bindArgumentD(BoundMethodHandle boundMethodHandle, int n, double d) {
        assert (boundMethodHandle.speciesData() == this.oldSpeciesData());
        LambdaForm.BasicType basicType = LambdaForm.BasicType.D_TYPE;
        MethodType methodType = this.bindArgumentType(boundMethodHandle, n, basicType);
        LambdaForm lambdaForm = this.bindArgumentForm(1 + n);
        return boundMethodHandle.copyWithExtendD(methodType, lambdaForm, d);
    }

    private MethodType bindArgumentType(BoundMethodHandle boundMethodHandle, int n, LambdaForm.BasicType basicType) {
        assert (boundMethodHandle.form == this.lambdaForm);
        assert (boundMethodHandle.form.names[1 + n].type == basicType);
        assert (LambdaForm.BasicType.basicType(boundMethodHandle.type().parameterType(n)) == basicType);
        return boundMethodHandle.type().dropParameterTypes(n, n + 1);
    }

    LambdaForm bindArgumentForm(int n) {
        Transform transform = Transform.of(Transform.Kind.BIND_ARG, n);
        LambdaForm lambdaForm = this.getInCache(transform);
        if (lambdaForm != null) {
            assert (lambdaForm.parameterConstraint(0) == this.newSpeciesData(this.lambdaForm.parameterType(n)));
            return lambdaForm;
        }
        LambdaFormBuffer lambdaFormBuffer = this.buffer();
        lambdaFormBuffer.startEdit();
        BoundMethodHandle.SpeciesData speciesData = this.oldSpeciesData();
        BoundMethodHandle.SpeciesData speciesData2 = this.newSpeciesData(this.lambdaForm.parameterType(n));
        LambdaForm.Name name = this.lambdaForm.parameter(0);
        LambdaForm.NamedFunction namedFunction = speciesData2.getterFunction(speciesData.fieldCount());
        if (n != 0) {
            lambdaFormBuffer.replaceFunctions(speciesData.getterFunctions(), speciesData2.getterFunctions(), name);
            LambdaForm.Name name2 = name.withConstraint(speciesData2);
            lambdaFormBuffer.renameParameter(0, name2);
            lambdaFormBuffer.replaceParameterByNewExpression(n, new LambdaForm.Name(namedFunction, name2));
        } else {
            assert (speciesData == BoundMethodHandle.SpeciesData.EMPTY);
            LambdaForm.Name name3 = new LambdaForm.Name(LambdaForm.BasicType.L_TYPE).withConstraint(speciesData2);
            lambdaFormBuffer.replaceParameterByNewExpression(0, new LambdaForm.Name(namedFunction, name3));
            lambdaFormBuffer.insertParameter(0, name3);
        }
        lambdaForm = lambdaFormBuffer.endEdit();
        return this.putInCache(transform, lambdaForm);
    }

    LambdaForm addArgumentForm(int n, LambdaForm.BasicType basicType) {
        Transform transform = Transform.of(Transform.Kind.ADD_ARG, n, basicType.ordinal());
        LambdaForm lambdaForm = this.getInCache(transform);
        if (lambdaForm != null) {
            assert (lambdaForm.arity == this.lambdaForm.arity + 1);
            assert (lambdaForm.parameterType(n) == basicType);
            return lambdaForm;
        }
        LambdaFormBuffer lambdaFormBuffer = this.buffer();
        lambdaFormBuffer.startEdit();
        lambdaFormBuffer.insertParameter(n, new LambdaForm.Name(basicType));
        lambdaForm = lambdaFormBuffer.endEdit();
        return this.putInCache(transform, lambdaForm);
    }

    LambdaForm dupArgumentForm(int n, int n2) {
        Transform transform = Transform.of(Transform.Kind.DUP_ARG, n, n2);
        LambdaForm lambdaForm = this.getInCache(transform);
        if (lambdaForm != null) {
            assert (lambdaForm.arity == this.lambdaForm.arity - 1);
            return lambdaForm;
        }
        LambdaFormBuffer lambdaFormBuffer = this.buffer();
        lambdaFormBuffer.startEdit();
        assert (this.lambdaForm.parameter((int)n).constraint == null);
        assert (this.lambdaForm.parameter((int)n2).constraint == null);
        lambdaFormBuffer.replaceParameterByCopy(n2, n);
        lambdaForm = lambdaFormBuffer.endEdit();
        return this.putInCache(transform, lambdaForm);
    }

    LambdaForm spreadArgumentsForm(int n, Class<?> clazz, int n2) {
        Transform transform;
        LambdaForm lambdaForm;
        Class<?> clazz2 = clazz.getComponentType();
        Class<Object> clazz3 = clazz;
        if (!clazz2.isPrimitive()) {
            clazz3 = Object[].class;
        }
        LambdaForm.BasicType basicType = LambdaForm.BasicType.basicType(clazz2);
        int n3 = basicType.ordinal();
        if (basicType.basicTypeClass() != clazz2 && clazz2.isPrimitive()) {
            n3 = LambdaForm.BasicType.TYPE_LIMIT + Wrapper.forPrimitiveType(clazz2).ordinal();
        }
        if ((lambdaForm = this.getInCache(transform = Transform.of(Transform.Kind.SPREAD_ARGS, n, n3, n2))) != null) {
            assert (lambdaForm.arity == this.lambdaForm.arity - n2 + 1);
            return lambdaForm;
        }
        LambdaFormBuffer lambdaFormBuffer = this.buffer();
        lambdaFormBuffer.startEdit();
        assert (n <= 255);
        assert (n + n2 <= this.lambdaForm.arity);
        assert (n > 0);
        LambdaForm.Name name = new LambdaForm.Name(LambdaForm.BasicType.L_TYPE);
        LambdaForm.Name name2 = new LambdaForm.Name(MethodHandleImpl.Lazy.NF_checkSpreadArgument, name, n2);
        int n4 = this.lambdaForm.arity();
        lambdaFormBuffer.insertExpression(n4++, name2);
        MethodHandle methodHandle = MethodHandles.arrayElementGetter(clazz3);
        for (int i = 0; i < n2; ++i) {
            LambdaForm.Name name3 = new LambdaForm.Name(methodHandle, name, i);
            lambdaFormBuffer.insertExpression(n4 + i, name3);
            lambdaFormBuffer.replaceParameterByCopy(n + i, n4 + i);
        }
        lambdaFormBuffer.insertParameter(n, name);
        lambdaForm = lambdaFormBuffer.endEdit();
        return this.putInCache(transform, lambdaForm);
    }

    LambdaForm collectArgumentsForm(int n, MethodType methodType) {
        Transform transform;
        LambdaForm lambdaForm;
        Transform.Kind kind;
        boolean bl;
        int n2 = methodType.parameterCount();
        boolean bl2 = bl = methodType.returnType() == Void.TYPE;
        if (n2 == 1 && !bl) {
            return this.filterArgumentForm(n, LambdaForm.BasicType.basicType(methodType.parameterType(0)));
        }
        LambdaForm.BasicType[] basicTypeArray = LambdaForm.BasicType.basicTypes(methodType.parameterList());
        Transform.Kind kind2 = kind = bl ? Transform.Kind.COLLECT_ARGS_TO_VOID : Transform.Kind.COLLECT_ARGS;
        if (bl && n2 == 0) {
            n = 1;
        }
        if ((lambdaForm = this.getInCache(transform = Transform.of(kind, n, n2, LambdaForm.BasicType.basicTypesOrd(basicTypeArray)))) != null) {
            assert (lambdaForm.arity == this.lambdaForm.arity - (bl ? 0 : 1) + n2);
            return lambdaForm;
        }
        lambdaForm = this.makeArgumentCombinationForm(n, methodType, false, bl);
        return this.putInCache(transform, lambdaForm);
    }

    LambdaForm collectArgumentArrayForm(int n, MethodHandle methodHandle) {
        MethodType methodType = methodHandle.type();
        int n2 = methodType.parameterCount();
        assert (methodHandle.intrinsicName() == MethodHandleImpl.Intrinsic.NEW_ARRAY);
        Class<?> clazz = methodType.returnType();
        Class<?> clazz2 = clazz.getComponentType();
        LambdaForm.BasicType basicType = LambdaForm.BasicType.basicType(clazz2);
        int n3 = basicType.ordinal();
        if (basicType.basicTypeClass() != clazz2) {
            if (!clazz2.isPrimitive()) {
                return null;
            }
            n3 = LambdaForm.BasicType.TYPE_LIMIT + Wrapper.forPrimitiveType(clazz2).ordinal();
        }
        assert (methodType.parameterList().equals(Collections.nCopies(n2, clazz2)));
        Transform.Kind kind = Transform.Kind.COLLECT_ARGS_TO_ARRAY;
        Transform transform = Transform.of(kind, n, n2, n3);
        LambdaForm lambdaForm = this.getInCache(transform);
        if (lambdaForm != null) {
            assert (lambdaForm.arity == this.lambdaForm.arity - 1 + n2);
            return lambdaForm;
        }
        LambdaFormBuffer lambdaFormBuffer = this.buffer();
        lambdaFormBuffer.startEdit();
        assert (n + 1 <= this.lambdaForm.arity);
        assert (n > 0);
        LambdaForm.Name[] nameArray = new LambdaForm.Name[n2];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = new LambdaForm.Name(n + i, basicType);
        }
        LambdaForm.Name name = new LambdaForm.Name(methodHandle, (Object[])nameArray);
        int n4 = this.lambdaForm.arity();
        lambdaFormBuffer.insertExpression(n4, name);
        int n5 = n + 1;
        for (LambdaForm.Name name2 : nameArray) {
            lambdaFormBuffer.insertParameter(n5++, name2);
        }
        assert (lambdaFormBuffer.lastIndexOf(name) == n4 + nameArray.length);
        lambdaFormBuffer.replaceParameterByCopy(n, n4 + nameArray.length);
        lambdaForm = lambdaFormBuffer.endEdit();
        return this.putInCache(transform, lambdaForm);
    }

    LambdaForm filterArgumentForm(int n, LambdaForm.BasicType basicType) {
        Transform transform = Transform.of(Transform.Kind.FILTER_ARG, n, basicType.ordinal());
        LambdaForm lambdaForm = this.getInCache(transform);
        if (lambdaForm != null) {
            assert (lambdaForm.arity == this.lambdaForm.arity);
            assert (lambdaForm.parameterType(n) == basicType);
            return lambdaForm;
        }
        LambdaForm.BasicType basicType2 = this.lambdaForm.parameterType(n);
        MethodType methodType = MethodType.methodType(basicType2.basicTypeClass(), basicType.basicTypeClass());
        lambdaForm = this.makeArgumentCombinationForm(n, methodType, false, false);
        return this.putInCache(transform, lambdaForm);
    }

    private LambdaForm makeArgumentCombinationForm(int n, MethodType methodType, boolean bl, boolean bl2) {
        int n2;
        Object object;
        LambdaForm.Name[] nameArray;
        int n3;
        LambdaFormBuffer lambdaFormBuffer = this.buffer();
        lambdaFormBuffer.startEdit();
        int n4 = methodType.parameterCount();
        int n5 = n3 = bl2 ? 0 : 1;
        assert (n <= 255);
        assert (n + n3 + (bl ? n4 : 0) <= this.lambdaForm.arity);
        assert (n > 0);
        assert (methodType == methodType.basicType());
        assert (methodType.returnType() != Void.TYPE || bl2);
        BoundMethodHandle.SpeciesData speciesData = this.oldSpeciesData();
        BoundMethodHandle.SpeciesData speciesData2 = this.newSpeciesData(LambdaForm.BasicType.L_TYPE);
        LambdaForm.Name name = this.lambdaForm.parameter(0);
        lambdaFormBuffer.replaceFunctions(speciesData.getterFunctions(), speciesData2.getterFunctions(), name);
        LambdaForm.Name name2 = name.withConstraint(speciesData2);
        lambdaFormBuffer.renameParameter(0, name2);
        LambdaForm.Name name3 = new LambdaForm.Name(speciesData2.getterFunction(speciesData.fieldCount()), name2);
        Object[] objectArray = new Object[1 + n4];
        objectArray[0] = name3;
        if (bl) {
            nameArray = new LambdaForm.Name[]{};
            System.arraycopy(this.lambdaForm.names, n + n3, objectArray, 1, n4);
        } else {
            nameArray = new LambdaForm.Name[n4];
            object = LambdaForm.BasicType.basicTypes(methodType.parameterList());
            for (n2 = 0; n2 < ((LambdaForm.BasicType[])object).length; ++n2) {
                nameArray[n2] = new LambdaForm.Name(n + n2, object[n2]);
            }
            System.arraycopy(nameArray, 0, objectArray, 1, n4);
        }
        object = new LambdaForm.Name(methodType, objectArray);
        n2 = this.lambdaForm.arity();
        lambdaFormBuffer.insertExpression(n2 + 0, name3);
        lambdaFormBuffer.insertExpression(n2 + 1, (LambdaForm.Name)object);
        int n6 = n + n3;
        for (LambdaForm.Name name4 : nameArray) {
            lambdaFormBuffer.insertParameter(n6++, name4);
        }
        assert (lambdaFormBuffer.lastIndexOf((LambdaForm.Name)object) == n2 + 1 + nameArray.length);
        if (!bl2) {
            lambdaFormBuffer.replaceParameterByCopy(n, n2 + 1 + nameArray.length);
        }
        return lambdaFormBuffer.endEdit();
    }

    LambdaForm filterReturnForm(LambdaForm.BasicType basicType, boolean bl) {
        LambdaForm.Name name;
        Transform.Kind kind = bl ? Transform.Kind.FILTER_RETURN_TO_ZERO : Transform.Kind.FILTER_RETURN;
        Transform transform = Transform.of(kind, basicType.ordinal());
        LambdaForm lambdaForm = this.getInCache(transform);
        if (lambdaForm != null) {
            assert (lambdaForm.arity == this.lambdaForm.arity);
            assert (lambdaForm.returnType() == basicType);
            return lambdaForm;
        }
        LambdaFormBuffer lambdaFormBuffer = this.buffer();
        lambdaFormBuffer.startEdit();
        int n = this.lambdaForm.names.length;
        if (bl) {
            name = basicType == LambdaForm.BasicType.V_TYPE ? null : new LambdaForm.Name(LambdaForm.constantZero(basicType), new Object[0]);
        } else {
            BoundMethodHandle.SpeciesData speciesData = this.oldSpeciesData();
            BoundMethodHandle.SpeciesData speciesData2 = this.newSpeciesData(LambdaForm.BasicType.L_TYPE);
            LambdaForm.Name name2 = this.lambdaForm.parameter(0);
            lambdaFormBuffer.replaceFunctions(speciesData.getterFunctions(), speciesData2.getterFunctions(), name2);
            LambdaForm.Name name3 = name2.withConstraint(speciesData2);
            lambdaFormBuffer.renameParameter(0, name3);
            LambdaForm.Name name4 = new LambdaForm.Name(speciesData2.getterFunction(speciesData.fieldCount()), name3);
            lambdaFormBuffer.insertExpression(n++, name4);
            LambdaForm.BasicType basicType2 = this.lambdaForm.returnType();
            if (basicType2 == LambdaForm.BasicType.V_TYPE) {
                MethodType methodType = MethodType.methodType(basicType.basicTypeClass());
                name = new LambdaForm.Name(methodType, name4);
            } else {
                MethodType methodType = MethodType.methodType(basicType.basicTypeClass(), basicType2.basicTypeClass());
                name = new LambdaForm.Name(methodType, name4, this.lambdaForm.names[this.lambdaForm.result]);
            }
        }
        if (name != null) {
            lambdaFormBuffer.insertExpression(n++, name);
        }
        lambdaFormBuffer.setResult(name);
        lambdaForm = lambdaFormBuffer.endEdit();
        return this.putInCache(transform, lambdaForm);
    }

    LambdaForm foldArgumentsForm(int n, boolean bl, MethodType methodType) {
        int n2;
        Transform.Kind kind = bl ? Transform.Kind.FOLD_ARGS_TO_VOID : Transform.Kind.FOLD_ARGS;
        Transform transform = Transform.of(kind, n, n2 = methodType.parameterCount());
        LambdaForm lambdaForm = this.getInCache(transform);
        if (lambdaForm != null) {
            assert (lambdaForm.arity == this.lambdaForm.arity - (kind == Transform.Kind.FOLD_ARGS ? 1 : 0));
            return lambdaForm;
        }
        lambdaForm = this.makeArgumentCombinationForm(n, methodType, true, bl);
        return this.putInCache(transform, lambdaForm);
    }

    LambdaForm permuteArgumentsForm(int n, int[] nArray) {
        int n2;
        LambdaForm.Name name;
        int n3;
        int n4;
        assert (n == 1);
        int n5 = this.lambdaForm.names.length;
        int n6 = nArray.length;
        int n7 = 0;
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            int n8 = nArray[i];
            if (n8 != i) {
                bl = false;
            }
            n7 = Math.max(n7, n8 + 1);
        }
        assert (n + nArray.length == this.lambdaForm.arity);
        if (bl) {
            return this.lambdaForm;
        }
        Transform transform = Transform.of(Transform.Kind.PERMUTE_ARGS, nArray);
        LambdaForm lambdaForm = this.getInCache(transform);
        if (lambdaForm != null) {
            assert (lambdaForm.arity == n + n7) : lambdaForm;
            return lambdaForm;
        }
        LambdaForm.BasicType[] basicTypeArray = new LambdaForm.BasicType[n7];
        for (n4 = 0; n4 < n6; ++n4) {
            int n9 = nArray[n4];
            basicTypeArray[n9] = this.lambdaForm.names[n + n4].type;
        }
        assert (n + n6 == this.lambdaForm.arity);
        assert (LambdaFormEditor.permutedTypesMatch(nArray, basicTypeArray, this.lambdaForm.names, n));
        for (n4 = 0; n4 < n6 && nArray[n4] == n4; ++n4) {
        }
        LambdaForm.Name[] nameArray = new LambdaForm.Name[n5 - n6 + n7];
        System.arraycopy(this.lambdaForm.names, 0, nameArray, 0, n + n4);
        int n10 = n5 - this.lambdaForm.arity;
        System.arraycopy(this.lambdaForm.names, n + n6, nameArray, n + n7, n10);
        int n11 = nameArray.length - n10;
        int n12 = this.lambdaForm.result;
        if (n12 >= 0) {
            n12 = n12 < n + n6 ? nArray[n12 - n] : n12 - n6 + n7;
        }
        for (n3 = n4; n3 < n6; ++n3) {
            LambdaForm.Name name2 = this.lambdaForm.names[n + n3];
            int n13 = nArray[n3];
            name = nameArray[n + n13];
            if (name == null) {
                nameArray[n + n13] = name = new LambdaForm.Name(basicTypeArray[n13]);
            } else assert (name.type == basicTypeArray[n13]);
            for (n2 = n11; n2 < nameArray.length; ++n2) {
                nameArray[n2] = nameArray[n2].replaceName(name2, name);
            }
        }
        for (n3 = n + n4; n3 < n11; ++n3) {
            if (nameArray[n3] != null) continue;
            nameArray[n3] = LambdaForm.argument(n3, basicTypeArray[n3 - n]);
        }
        for (n3 = this.lambdaForm.arity; n3 < this.lambdaForm.names.length; ++n3) {
            LambdaForm.Name name3 = this.lambdaForm.names[n3];
            int n14 = n3 - this.lambdaForm.arity + n11;
            name = nameArray[n14];
            if (name3 == name) continue;
            for (n2 = n14 + 1; n2 < nameArray.length; ++n2) {
                nameArray[n2] = nameArray[n2].replaceName(name3, name);
            }
        }
        lambdaForm = new LambdaForm(this.lambdaForm.debugName, n11, nameArray, n12);
        return this.putInCache(transform, lambdaForm);
    }

    static boolean permutedTypesMatch(int[] nArray, LambdaForm.BasicType[] basicTypeArray, LambdaForm.Name[] nameArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            assert (nameArray[n + i].isParam());
            assert (nameArray[n + i].type == basicTypeArray[nArray[i]]);
        }
        return true;
    }

    private static final class Transform
    extends SoftReference<LambdaForm> {
        final long packedBytes;
        final byte[] fullBytes;
        private static final boolean STRESS_TEST = false;
        private static final int PACKED_BYTE_SIZE = 4;
        private static final int PACKED_BYTE_MASK = 15;
        private static final int PACKED_BYTE_MAX_LENGTH = 16;
        private static final byte[] NO_BYTES = new byte[0];

        private static long packedBytes(byte[] byArray) {
            if (byArray.length > 16) {
                return 0L;
            }
            long l = 0L;
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                int n2 = byArray[i] & 0xFF;
                n |= n2;
                l |= (long)n2 << i * 4;
            }
            if (!Transform.inRange(n)) {
                return 0L;
            }
            return l;
        }

        private static long packedBytes(int n, int n2) {
            assert (Transform.inRange(n | n2));
            return n << 0 | n2 << 4;
        }

        private static long packedBytes(int n, int n2, int n3) {
            assert (Transform.inRange(n | n2 | n3));
            return n << 0 | n2 << 4 | n3 << 8;
        }

        private static long packedBytes(int n, int n2, int n3, int n4) {
            assert (Transform.inRange(n | n2 | n3 | n4));
            return n << 0 | n2 << 4 | n3 << 8 | n4 << 12;
        }

        private static boolean inRange(int n) {
            assert ((n & 0xFF) == n);
            return (n & 0xFFFFFFF0) == 0;
        }

        private static byte[] fullBytes(int ... nArray) {
            byte[] byArray = new byte[nArray.length];
            int n = 0;
            for (int n2 : nArray) {
                byArray[n++] = Transform.bval(n2);
            }
            assert (Transform.packedBytes(byArray) == 0L);
            return byArray;
        }

        private byte byteAt(int n) {
            long l = this.packedBytes;
            if (l == 0L) {
                if (n >= this.fullBytes.length) {
                    return 0;
                }
                return this.fullBytes[n];
            }
            assert (this.fullBytes == null);
            if (n > 16) {
                return 0;
            }
            int n2 = n * 4;
            return (byte)(l >>> n2 & 0xFL);
        }

        Kind kind() {
            return Kind.values()[this.byteAt(0)];
        }

        private Transform(long l, byte[] byArray, LambdaForm lambdaForm) {
            super(lambdaForm);
            this.packedBytes = l;
            this.fullBytes = byArray;
        }

        private Transform(long l) {
            this(l, null, null);
            assert (l != 0L);
        }

        private Transform(byte[] byArray) {
            this(0L, byArray, null);
        }

        private static byte bval(int n) {
            assert ((n & 0xFF) == n);
            return (byte)n;
        }

        private static byte bval(Kind kind) {
            return Transform.bval(kind.ordinal());
        }

        static Transform of(Kind kind, int n) {
            byte by = Transform.bval(kind);
            if (Transform.inRange(by | n)) {
                return new Transform(Transform.packedBytes(by, n));
            }
            return new Transform(Transform.fullBytes(by, n));
        }

        static Transform of(Kind kind, int n, int n2) {
            byte by = (byte)kind.ordinal();
            if (Transform.inRange(by | n | n2)) {
                return new Transform(Transform.packedBytes(by, n, n2));
            }
            return new Transform(Transform.fullBytes(by, n, n2));
        }

        static Transform of(Kind kind, int n, int n2, int n3) {
            byte by = (byte)kind.ordinal();
            if (Transform.inRange(by | n | n2 | n3)) {
                return new Transform(Transform.packedBytes(by, n, n2, n3));
            }
            return new Transform(Transform.fullBytes(by, n, n2, n3));
        }

        static Transform of(Kind kind, int ... nArray) {
            return Transform.ofBothArrays(kind, nArray, NO_BYTES);
        }

        static Transform of(Kind kind, int n, byte[] byArray) {
            return Transform.ofBothArrays(kind, new int[]{n}, byArray);
        }

        static Transform of(Kind kind, int n, int n2, byte[] byArray) {
            return Transform.ofBothArrays(kind, new int[]{n, n2}, byArray);
        }

        private static Transform ofBothArrays(Kind kind, int[] nArray, byte[] byArray) {
            byte[] byArray2 = new byte[1 + nArray.length + byArray.length];
            int n = 0;
            byArray2[n++] = Transform.bval(kind);
            for (int n2 : nArray) {
                byArray2[n++] = Transform.bval(n2);
            }
            for (int n2 : byArray) {
                byArray2[n++] = n2;
            }
            long l = Transform.packedBytes(byArray2);
            if (l != 0L) {
                return new Transform(l);
            }
            return new Transform(byArray2);
        }

        Transform withResult(LambdaForm lambdaForm) {
            return new Transform(this.packedBytes, this.fullBytes, lambdaForm);
        }

        public boolean equals(Object object) {
            return object instanceof Transform && this.equals((Transform)object);
        }

        public boolean equals(Transform transform) {
            return this.packedBytes == transform.packedBytes && Arrays.equals(this.fullBytes, transform.fullBytes);
        }

        public int hashCode() {
            if (this.packedBytes != 0L) {
                assert (this.fullBytes == null);
                return Long.hashCode(this.packedBytes);
            }
            return Arrays.hashCode(this.fullBytes);
        }

        public String toString() {
            LambdaForm lambdaForm;
            StringBuilder stringBuilder = new StringBuilder();
            long l = this.packedBytes;
            if (l != 0L) {
                stringBuilder.append("(");
                while (l != 0L) {
                    stringBuilder.append(l & 0xFL);
                    if ((l >>>= 4) == 0L) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append(")");
            }
            if (this.fullBytes != null) {
                stringBuilder.append("unpacked");
                stringBuilder.append(Arrays.toString(this.fullBytes));
            }
            if ((lambdaForm = (LambdaForm)this.get()) != null) {
                stringBuilder.append(" result=");
                stringBuilder.append(lambdaForm);
            }
            return stringBuilder.toString();
        }

        private static enum Kind {
            NO_KIND,
            BIND_ARG,
            ADD_ARG,
            DUP_ARG,
            SPREAD_ARGS,
            FILTER_ARG,
            FILTER_RETURN,
            FILTER_RETURN_TO_ZERO,
            COLLECT_ARGS,
            COLLECT_ARGS_TO_VOID,
            COLLECT_ARGS_TO_ARRAY,
            FOLD_ARGS,
            FOLD_ARGS_TO_VOID,
            PERMUTE_ARGS;

        }
    }
}

