/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.NewInstance;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.SecuritySupport;

public final class XMLReaderFactory {
    private static final String property = "org.xml.sax.driver";
    private static SecuritySupport ss = new SecuritySupport();
    private static String _clsFromJar = null;
    private static boolean _jarread = false;

    private XMLReaderFactory() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        String string = null;
        ClassLoader classLoader = ss.getContextClassLoader();
        try {
            string = ss.getSystemProperty(property);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (string == null) {
            if (!_jarread) {
                _jarread = true;
                String string2 = "META-INF/services/org.xml.sax.driver";
                try {
                    InputStream inputStream;
                    if (classLoader != null) {
                        inputStream = ss.getResourceAsStream(classLoader, string2);
                        if (inputStream == null) {
                            classLoader = null;
                            inputStream = ss.getResourceAsStream(classLoader, string2);
                        }
                    } else {
                        inputStream = ss.getResourceAsStream(classLoader, string2);
                    }
                    if (inputStream != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
                        _clsFromJar = bufferedReader.readLine();
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string = _clsFromJar;
        }
        if (string == null) {
            string = "com.sun.org.apache.xerces.internal.parsers.SAXParser";
        }
        if (string != null) {
            return XMLReaderFactory.loadClass(classLoader, string);
        }
        try {
            return new ParserAdapter(ParserFactory.makeParser());
        }
        catch (Exception exception) {
            throw new SAXException("Can't create default XMLReader; is system property org.xml.sax.driver set?");
        }
    }

    public static XMLReader createXMLReader(String string) throws SAXException {
        return XMLReaderFactory.loadClass(ss.getContextClassLoader(), string);
    }

    private static XMLReader loadClass(ClassLoader classLoader, String string) throws SAXException {
        try {
            return (XMLReader)NewInstance.newInstance(classLoader, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXException("SAX2 driver class " + string + " not found", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException("SAX2 driver class " + string + " found but cannot be loaded", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException("SAX2 driver class " + string + " loaded but cannot be instantiated (no empty public constructor?)", instantiationException);
        }
        catch (ClassCastException classCastException) {
            throw new SAXException("SAX2 driver class " + string + " does not implement XMLReader", classCastException);
        }
    }
}

