/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.webservices.internal.api.message;

import com.oracle.webservices.internal.api.message.PropertySet;
import com.oracle.webservices.internal.api.message.ReadOnlyPropertyException;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class BasePropertySet
implements PropertySet {
    private Map<String, Object> mapView;

    protected BasePropertySet() {
    }

    protected abstract PropertyMap getPropertyMap();

    protected static PropertyMap parse(final Class clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<PropertyMap>(){

            @Override
            public PropertyMap run() {
                PropertyMap propertyMap = new PropertyMap();
                for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                    PropertySet.Property property;
                    for (Field field : clazz2.getDeclaredFields()) {
                        property = field.getAnnotation(PropertySet.Property.class);
                        if (property == null) continue;
                        for (String string : property.value()) {
                            propertyMap.put(string, new FieldAccessor(field, string));
                        }
                    }
                    for (AccessibleObject accessibleObject : clazz2.getDeclaredMethods()) {
                        Method method;
                        property = ((Method)accessibleObject).getAnnotation(PropertySet.Property.class);
                        if (property == null) continue;
                        String string = ((Method)accessibleObject).getName();
                        assert (string.startsWith("get") || string.startsWith("is"));
                        String string2 = string.startsWith("is") ? "set" + string.substring(2) : 's' + string.substring(1);
                        try {
                            method = clazz.getMethod(string2, ((Method)accessibleObject).getReturnType());
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            method = null;
                        }
                        for (String string3 : property.value()) {
                            propertyMap.put(string3, new MethodAccessor((Method)accessibleObject, method, string3));
                        }
                    }
                }
                return propertyMap;
            }
        });
    }

    @Override
    public boolean containsKey(Object object) {
        Accessor accessor = (Accessor)this.getPropertyMap().get(object);
        if (accessor != null) {
            return accessor.get(this) != null;
        }
        return false;
    }

    @Override
    public Object get(Object object) {
        Accessor accessor = (Accessor)this.getPropertyMap().get(object);
        if (accessor != null) {
            return accessor.get(this);
        }
        throw new IllegalArgumentException("Undefined property " + object);
    }

    @Override
    public Object put(String string, Object object) {
        Accessor accessor = (Accessor)this.getPropertyMap().get(string);
        if (accessor != null) {
            Object object2 = accessor.get(this);
            accessor.set(this, object);
            return object2;
        }
        throw new IllegalArgumentException("Undefined property " + string);
    }

    @Override
    public boolean supports(Object object) {
        return this.getPropertyMap().containsKey(object);
    }

    @Override
    public Object remove(Object object) {
        Accessor accessor = (Accessor)this.getPropertyMap().get(object);
        if (accessor != null) {
            Object object2 = accessor.get(this);
            accessor.set(this, null);
            return object2;
        }
        throw new IllegalArgumentException("Undefined property " + object);
    }

    @Override
    @Deprecated
    public final Map<String, Object> createMapView() {
        final HashSet<Map.Entry<String, Object>> hashSet = new HashSet<Map.Entry<String, Object>>();
        this.createEntrySet(hashSet);
        return new AbstractMap<String, Object>(){

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return hashSet;
            }
        };
    }

    @Override
    public Map<String, Object> asMap() {
        if (this.mapView == null) {
            this.mapView = this.createView();
        }
        return this.mapView;
    }

    protected Map<String, Object> createView() {
        return new MapView(this.mapAllowsAdditionalProperties());
    }

    protected boolean mapAllowsAdditionalProperties() {
        return false;
    }

    protected void createEntrySet(Set<Map.Entry<String, Object>> set) {
        for (final Map.Entry entry : this.getPropertyMap().entrySet()) {
            set.add(new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return (String)entry.getKey();
                }

                @Override
                public Object getValue() {
                    return ((Accessor)entry.getValue()).get(BasePropertySet.this);
                }

                @Override
                public Object setValue(Object object) {
                    Accessor accessor = (Accessor)entry.getValue();
                    Object object2 = accessor.get(BasePropertySet.this);
                    accessor.set(BasePropertySet.this, object);
                    return object2;
                }
            });
        }
    }

    protected static interface Accessor {
        public String getName();

        public boolean hasValue(PropertySet var1);

        public Object get(PropertySet var1);

        public void set(PropertySet var1, Object var2);
    }

    static final class FieldAccessor
    implements Accessor {
        private final Field f;
        private final String name;

        protected FieldAccessor(Field field, String string) {
            this.f = field;
            field.setAccessible(true);
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean hasValue(PropertySet propertySet) {
            return this.get(propertySet) != null;
        }

        @Override
        public Object get(PropertySet propertySet) {
            try {
                return this.f.get(propertySet);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }

        @Override
        public void set(PropertySet propertySet, Object object) {
            try {
                this.f.set(propertySet, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }
    }

    final class MapView
    extends HashMap<String, Object> {
        boolean extensible;

        MapView(boolean bl) {
            super(BasePropertySet.this.getPropertyMap().getPropertyMapEntries().length);
            this.extensible = bl;
            this.initialize();
        }

        public void initialize() {
            PropertyMapEntry[] propertyMapEntryArray;
            for (PropertyMapEntry propertyMapEntry : propertyMapEntryArray = BasePropertySet.this.getPropertyMap().getPropertyMapEntries()) {
                super.put(propertyMapEntry.key, propertyMapEntry.value);
            }
        }

        @Override
        public Object get(Object object) {
            Object v = super.get(object);
            if (v instanceof Accessor) {
                return ((Accessor)v).get(BasePropertySet.this);
            }
            return v;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            HashSet<Map.Entry<String, Object>> hashSet = new HashSet<Map.Entry<String, Object>>();
            for (String string : this.keySet()) {
                hashSet.add(new AbstractMap.SimpleImmutableEntry<String, Object>(string, this.get(string)));
            }
            return hashSet;
        }

        @Override
        public Object put(String string, Object object) {
            Object v = super.get(string);
            if (v != null && v instanceof Accessor) {
                Object object2 = ((Accessor)v).get(BasePropertySet.this);
                ((Accessor)v).set(BasePropertySet.this, object);
                return object2;
            }
            if (this.extensible) {
                return super.put(string, object);
            }
            throw new IllegalStateException("Unknown property [" + string + "] for PropertySet [" + BasePropertySet.this.getClass().getName() + "]");
        }

        @Override
        public void clear() {
            for (String string : this.keySet()) {
                this.remove(string);
            }
        }

        @Override
        public Object remove(Object object) {
            Object v = super.get(object);
            if (v instanceof Accessor) {
                ((Accessor)v).set(BasePropertySet.this, null);
            }
            return super.remove(object);
        }
    }

    static final class MethodAccessor
    implements Accessor {
        @NotNull
        private final Method getter;
        @Nullable
        private final Method setter;
        private final String name;

        protected MethodAccessor(Method method, Method method2, String string) {
            this.getter = method;
            this.setter = method2;
            this.name = string;
            method.setAccessible(true);
            if (method2 != null) {
                method2.setAccessible(true);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean hasValue(PropertySet propertySet) {
            return this.get(propertySet) != null;
        }

        @Override
        public Object get(PropertySet propertySet) {
            try {
                return this.getter.invoke(propertySet, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.handle(invocationTargetException);
                return 0;
            }
        }

        @Override
        public void set(PropertySet propertySet, Object object) {
            if (this.setter == null) {
                throw new ReadOnlyPropertyException(this.getName());
            }
            try {
                this.setter.invoke(propertySet, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.handle(invocationTargetException);
            }
        }

        private Exception handle(InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new Error(invocationTargetException);
        }
    }

    protected static class PropertyMap
    extends HashMap<String, Accessor> {
        transient PropertyMapEntry[] cachedEntries = null;

        protected PropertyMap() {
        }

        PropertyMapEntry[] getPropertyMapEntries() {
            if (this.cachedEntries == null) {
                this.cachedEntries = this.createPropertyMapEntries();
            }
            return this.cachedEntries;
        }

        private PropertyMapEntry[] createPropertyMapEntries() {
            PropertyMapEntry[] propertyMapEntryArray = new PropertyMapEntry[this.size()];
            int n = 0;
            for (Map.Entry entry : this.entrySet()) {
                propertyMapEntryArray[n++] = new PropertyMapEntry((String)entry.getKey(), (Accessor)entry.getValue());
            }
            return propertyMapEntryArray;
        }
    }

    public static class PropertyMapEntry {
        String key;
        Accessor value;

        public PropertyMapEntry(String string, Accessor accessor) {
            this.key = string;
            this.value = accessor;
        }
    }
}

