var drawArrow=function(ctx,x1,y1,x2,y2,style,which,angle,d)
{
  'use strict';
  
  if(typeof(x1)=='string') x1=parseInt(x1);
  if(typeof(y1)=='string') y1=parseInt(y1);
  if(typeof(x2)=='string') x2=parseInt(x2);
  if(typeof(y2)=='string') y2=parseInt(y2);
  style=typeof(style)!='undefined'? style:3;
  which=typeof(which)!='undefined'? which:1; 
  angle=typeof(angle)!='undefined'? angle:Math.PI/8;
  d    =typeof(d)    !='undefined'? d    :10;
  
  var toDrawHead=typeof(style)!='function'?drawHead:style;

  var dist=Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
  var ratio=(dist-d/3)/dist;
  var tox, toy,fromx,fromy;
  if(which&1){
    tox=Math.round(x1+(x2-x1)*ratio);
    toy=Math.round(y1+(y2-y1)*ratio);
  }else{
    tox=x2;
    toy=y2;
  }
  if(which&2){
    fromx=x1+(x2-x1)*(1-ratio);
    fromy=y1+(y2-y1)*(1-ratio);
  }else{
    fromx=x1;
    fromy=y1;
  }

  
  ctx.beginPath();
  ctx.moveTo(fromx,fromy);
  ctx.lineTo(tox,toy);
  ctx.stroke();

  
  var lineangle=Math.atan2(y2-y1,x2-x1);
  
  var h=Math.abs(d/Math.cos(angle));

  if(which&1){	
    var angle1=lineangle+Math.PI+angle;
    var topx=x2+Math.cos(angle1)*h;
    var topy=y2+Math.sin(angle1)*h;
    var angle2=lineangle+Math.PI-angle;
    var botx=x2+Math.cos(angle2)*h;
    var boty=y2+Math.sin(angle2)*h;
    toDrawHead(ctx,topx,topy,x2,y2,botx,boty,style);
  }
  if(which&2){ 
    var angle1=lineangle+angle;
    var topx=x1+Math.cos(angle1)*h;
    var topy=y1+Math.sin(angle1)*h;
    var angle2=lineangle-angle;
    var botx=x1+Math.cos(angle2)*h;
    var boty=y1+Math.sin(angle2)*h;
    toDrawHead(ctx,topx,topy,x1,y1,botx,boty,style);
  }
}

var drawHead=function(ctx,x0,y0,x1,y1,x2,y2,style)
{
  'use strict';
  if(typeof(x0)=='string') x0=parseInt(x0);
  if(typeof(y0)=='string') y0=parseInt(y0);
  if(typeof(x1)=='string') x1=parseInt(x1);
  if(typeof(y1)=='string') y1=parseInt(y1);
  if(typeof(x2)=='string') x2=parseInt(x2);
  if(typeof(y2)=='string') y2=parseInt(y2);
  var radius=3;
  var twoPI=2*Math.PI;

  
  ctx.save();
  ctx.beginPath();
  ctx.moveTo(x0,y0);
  ctx.lineTo(x1,y1);
  ctx.lineTo(x2,y2);
  switch(style){
    case 0:
      
      var backdist=Math.sqrt(((x2-x0)*(x2-x0))+((y2-y0)*(y2-y0)));
      ctx.arcTo(x1,y1,x0,y0,.55*backdist);
      ctx.fill();
      break;
    case 1:
      
      ctx.beginPath();
      ctx.moveTo(x0,y0);
      ctx.lineTo(x1,y1);
      ctx.lineTo(x2,y2);
      ctx.lineTo(x0,y0);
      ctx.fill();
      break;
    case 2:
      
      ctx.stroke();
      break;
    case 3:
      
      var cpx=(x0+x1+x2)/3;
      var cpy=(y0+y1+y2)/3;
      ctx.quadraticCurveTo(cpx,cpy,x0,y0);
      ctx.fill();
      break;
    case 4:
      
      var cp1x, cp1y, cp2x, cp2y,backdist;
      var shiftamt=5;
      if(x2==x0){
	
	backdist=y2-y0;
	cp1x=(x1+x0)/2;
	cp2x=(x1+x0)/2;
	cp1y=y1+backdist/shiftamt;
	cp2y=y1-backdist/shiftamt;
      }else{
	backdist=Math.sqrt(((x2-x0)*(x2-x0))+((y2-y0)*(y2-y0)));
	var xback=(x0+x2)/2;
	var yback=(y0+y2)/2;
	var xmid=(xback+x1)/2;
	var ymid=(yback+y1)/2;

	var m=(y2-y0)/(x2-x0);
	var dx=(backdist/(2*Math.sqrt(m*m+1)))/shiftamt;
	var dy=m*dx;
	cp1x=xmid-dx;
	cp1y=ymid-dy;
	cp2x=xmid+dx;
	cp2y=ymid+dy;
      }

      ctx.bezierCurveTo(cp1x,cp1y,cp2x,cp2y,x0,y0);
      ctx.fill();
      break;
  }
  ctx.restore();
};



var DYN_WEB = DYN_WEB || {};

DYN_WEB.Event=(function(Ev){Ev.add=document.addEventListener?function(obj,etype,fp,cap){cap=cap||false;obj.addEventListener(etype,fp,cap);}:function(obj,etype,fp){obj.attachEvent('on'+etype,fp);};Ev.remove=document.removeEventListener?function(obj,etype,fp,cap){cap=cap||false;obj.removeEventListener(etype,fp,cap);}:function(obj,etype,fp){obj.detachEvent('on'+etype,fp);};Ev.DOMit=function(e){e=e?e:window.event;if(!e.target){e.target=e.srcElement;}if(!e.preventDefault){e.preventDefault=function(){e.returnValue=false;return false;};}if(!e.stopPropagation){e.stopPropagation=function(){e.cancelBubble=true;};}return e;};Ev.getTarget=function(e){e=Ev.DOMit(e);var tgt=e.target;if(tgt.nodeType!==1){tgt=tgt.parentNode;}return tgt;};Ev.domReady=(function(){var funcs=[];var ready=false;function handler(e){if(ready){return;}if(e.type==="readystatechange"&&document.readyState!=="complete"){return;}for(var i=0,len=funcs.length;i<len;i++){funcs[i].call(document);}ready=true;funcs=[];}if(document.addEventListener){document.addEventListener("DOMContentLoaded",handler,false);document.addEventListener("readystatechange",handler,false);window.addEventListener("load",handler,false);}else if(document.attachEvent){document.attachEvent("onreadystatechange",handler);window.attachEvent("onload",handler);}return function whenReady(f){if(ready){f.call(document);}else{funcs.push(f);}};})();return Ev;})(DYN_WEB.Event||{});

DYN_WEB.Viewport={_docEl:null,getDocEl:function(){var mode='',doc=document;if(!this._docEl){mode=doc.compatMode;this._docEl=(mode==='CSS1Compat')?doc.documentElement:doc.body;}return this._docEl;},getWidth:function(){var width=this.getDocEl().clientWidth;if(window.innerWidth&&width>window.innerWidth){width=window.innerWidth;}return width;},getHeight:function(){var height=this.getDocEl().clientHeight;if(window.innerHeight&&height>window.innerHeight){height=window.innerHeight;}return height;},getScrollX:function(){var sx=(typeof window.pageXOffset==='number')?window.pageXOffset:this.getDocEl().scrollLeft;return sx;},getScrollY:function(){var sy=(typeof window.pageYOffset==='number')?window.pageYOffset:this.getDocEl().scrollTop;return sy;},getAll:function(){return{width:this.getWidth(),height:this.getHeight(),scrollX:this.getScrollX(),scrollY:this.getScrollY()};}};

DYN_WEB.Util=(function(Ut){Ut.$=function(id){return document.getElementById(id);};Ut.getCurrentStyle=function(el,prop){var val='',style,runtimeStyle;if(window.getComputedStyle){val=window.getComputedStyle(el,null)[prop];}else if(el.currentStyle){val=el.currentStyle[prop];if(!/^\d+(px)?$/i.test(val)&&/^\d/.test(val)){style=el.style.left;runtimeStyle=el.runtimeStyle.left;el.runtimeStyle.left=el.currentStyle.left;el.style.left=val||0;val=el.style.pixelLeft+"px";el.style.left=style;el.runtimeStyle.left=runtimeStyle;}}return val;};Ut.contained=function(oNode,oCont){if(!oNode){return false;}while((oNode=oNode.parentNode)){if(oNode===oCont){return true;}}return false;};return Ut;})(DYN_WEB.Util||{});

DYN_WEB.Draggable=(function(){var Ut=DYN_WEB.Util,Ev=DYN_WEB.Event,VP=DYN_WEB.Viewport;function D(id,handleId,opts){var el=Ut.$(id);if(!el){throw new Error('new DYN_WEB.Draggable: No element with the specified id found.');}this.id=id;D.col[id]=this;var handle;var x=parseInt(Ut.getCurrentStyle(el,'left'),10);var y=parseInt(Ut.getCurrentStyle(el,'top'),10);x=isNaN(x)?0:x;y=isNaN(y)?0:y;if(opts){this.minX=(typeof opts.minX==='number')?opts.minX:undefined;this.maxX=(typeof opts.maxX==='number')?opts.maxX:undefined;this.minY=(typeof opts.minY==='number')?opts.minY:undefined;this.maxY=(typeof opts.maxY==='number')?opts.maxY:undefined;this.on_drag_start=(typeof opts.on_drag_start==='function')?opts.on_drag_start:this.on_drag_start;this.on_drag=(typeof opts.on_drag==='function')?opts.on_drag:this.on_drag;this.on_drag_end=(typeof opts.on_drag_end==='function')?opts.on_drag_end:this.on_drag_end;}D.shiftTo(el,x,y);if(handleId){handle=Ut.$(handleId);if(!handle){throw new Error('new DYN_WEB.Draggable: No element with the specified handleId found.');}else if(!Ut.contained(handle,el)){throw new Error('new DYN_WEB.Draggable: No element with id '+handleId+' found inside '+id+'.');}}else{handle=el;}Ev.add(handle,'mousedown',D.start);}D.prototype={on_drag_start:function(){},on_drag:function(){},on_drag_end:function(){}};D.col={};D.current='';D.zOrder=1000;D.start=function(e){var el,_this,downX,downY,x,y,ctr=0,maxLoops=10;e=Ev.DOMit(e);var tgt=Ev.getTarget(e);do{if(tgt.id&&(_this=D.col[tgt.id])){el=Ut.$(tgt.id);D.current=tgt.id;break;}ctr++;}while(ctr<maxLoops&&(tgt=tgt.parentNode));if(!el){throw new Error('Unable to find Draggable element onmousedown.');}el.style.zIndex=D.zOrder++;downX=e.clientX+VP.getScrollX();downY=e.clientY+VP.getScrollY();x=parseInt(el.style.left,10)||0;y=parseInt(el.style.top,10)||0;_this.dx=downX-x;_this.dy=downY-y;_this.on_drag_start(x,y);Ev.add(document,'mousemove',D.drag);Ev.add(document,'mouseup',D.end);e.preventDefault();e.stopPropagation();};D.drag=function(e){e=Ev.DOMit(e);var _this=D.col[D.current],el=Ut.$(D.current),nx=e.clientX+VP.getScrollX()-_this.dx,ny=e.clientY+VP.getScrollY()-_this.dy;nx=(typeof _this.minX!=='undefined')?Math.max(_this.minX,nx):nx;nx=(typeof _this.maxX!=='undefined')?Math.min(_this.maxX,nx):nx;ny=(typeof _this.minY!=='undefined')?Math.max(_this.minY,ny):ny;ny=(typeof _this.maxY!=='undefined')?Math.min(_this.maxY,ny):ny;D.shiftTo(el,nx,ny);_this.on_drag(nx,ny);e.preventDefault();};D.end=function(){var _this=D.col[D.current],el=Ut.$(D.current),x,y;Ev.remove(document,'mousemove',D.drag);Ev.remove(document,'mouseup',D.end);if(el){x=parseInt(el.style.left,10);y=parseInt(el.style.top,10);_this.on_drag_end(x,y);}D.current='';};D.setup=function(){var cur;for(var i=0,len=arguments.length;i<len;i++){cur=arguments[i];if(typeof cur==='string'){new D(cur);}else{new D(cur.id,cur.handleId,cur);}}};D.shiftTo=function(el,x,y){el.style.left=parseInt(x,10)+'px';el.style.top=parseInt(y,10)+'px';};return D;})();

DYN_WEB.Slider=(function(){var Ut=DYN_WEB.Util,Ev=DYN_WEB.Event,Drag=DYN_WEB.Draggable;function SC(id,trackId,axis){this.id=id;this.trackId=trackId;this.axis=axis;SC.col[this.id]=this;this.init();}SC.col={};SC.prototype={slideDur:500,init:function(){var bar=Ut.$(this.id),track=Ut.$(this.trackId),x=parseInt(Ut.getCurrentStyle(bar,'left'),10),y=parseInt(Ut.getCurrentStyle(bar,'top'),10),maxX,maxY,opts,self=this;x=isNaN(x)?0:x;y=isNaN(y)?0:y;if(this.axis==='v'){maxY=track.offsetHeight-bar.offsetHeight-2*track.clientTop;opts={minX:x,maxX:x,minY:0,maxY:maxY};}else{maxX=track.offsetWidth-bar.offsetWidth-2*track.clientLeft;opts={minX:0,maxX:maxX,minY:y,maxY:y};}this.barWd=bar.offsetWidth;this.barHt=bar.offsetHeight;this.Dragbar=new Drag(this.id,'',opts);this.minX=this.Dragbar.minX;this.maxX=this.Dragbar.maxX;this.minY=this.Dragbar.minY;this.maxY=this.Dragbar.maxY;this.Dragbar.on_drag_start=function(x,y){self.on_move_start(x,y);};this.Dragbar.on_drag=function(x,y){self.on_move(x,y);};this.Dragbar.on_drag_end=function(x,y){self.on_move_end(x,y);};Ev.add(track,'mousedown',function(e){self.prepSlide(e,self.id);});},prepSlide:function(e,id){e=Ev.DOMit(e);var self=SC.col[id];var bar=self.bar=Ut.$(id);self.clearTimer();e.offX=(typeof e.offsetX==='number')?e.offsetX:e.layerX;e.offY=(typeof e.offsetY==='number')?e.offsetY:e.layerY;self.startX=parseInt(bar.style.left,10);self.startY=parseInt(bar.style.top,10);if(self.axis==="v"){self.destX=self.startX;self.destY=(e.offY<self.startY)?e.offY:e.offY-self.barHt;self.destY=Math.min(Math.max(self.destY,self.minY),self.maxY);}else{self.destX=(e.offX<self.startX)?e.offX:e.offX-self.barWd;self.destX=Math.min(Math.max(self.destX,self.minX),self.maxX);self.destY=self.startY;}self.distX=self.destX-self.startX;self.distY=self.destY-self.startY;self.per=Math.PI/(2*self.slideDur);self.slideStartTime=new Date().getTime();self.on_move_start(self.startX,self.startY);self.timerId=setInterval(function(){self.doSlide();},10);},doSlide:function(){var elapsed=new Date().getTime()-this.slideStartTime;if(elapsed<this.slideDur){var x=this.startX+this.distX*Math.sin(this.per*elapsed);var y=this.startY+this.distY*Math.sin(this.per*elapsed);this.shiftTo(x,y);this.on_move(x,y);}else{this.clearTimer();this.shiftTo(this.destX,this.destY);this.on_move(this.destX,this.destY);this.on_move_end(this.destX,this.destY);}},shiftTo:function(x,y){if(this.bar&&!isNaN(x)&&!isNaN(y)){this.bar.style.left=Math.round(x)+"px";this.bar.style.top=Math.round(y)+"px";}},clearTimer:function(){clearInterval(this.timerId);this.timerId=0;},on_move_start:function(x,y){},on_move:function(x,y){},on_move_end:function(x,y){}};return SC;})();