/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHPrimitiveType;
import bsh.BshClassManager;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.SimpleNode;
import java.lang.reflect.Array;

class BSHType
extends SimpleNode
implements BshClassManager.Listener {
    private Class baseType;
    private int arrayDims;
    private Class type;

    BSHType(int n) {
        super(n);
    }

    public void addArrayDimension() {
        ++this.arrayDims;
    }

    SimpleNode getTypeNode() {
        return (SimpleNode)this.jjtGetChild(0);
    }

    public Class getType(CallStack callStack, Interpreter interpreter) throws EvalError {
        if (this.type != null) {
            return this.type;
        }
        SimpleNode simpleNode = this.getTypeNode();
        this.baseType = simpleNode instanceof BSHPrimitiveType ? ((BSHPrimitiveType)simpleNode).getType() : ((BSHAmbiguousName)simpleNode).toClass(callStack, interpreter);
        if (this.arrayDims > 0) {
            try {
                int[] nArray = new int[this.arrayDims];
                Object object = Array.newInstance(this.baseType, nArray);
                this.type = object.getClass();
            }
            catch (Exception exception) {
                throw new EvalError("Couldn't construct array type", this, callStack);
            }
        } else {
            this.type = this.baseType;
        }
        interpreter.getClassManager().addListener(this);
        return this.type;
    }

    public Class getBaseType() {
        return this.baseType;
    }

    public int getArrayDims() {
        return this.arrayDims;
    }

    public void classLoaderChanged() {
        this.type = null;
        this.baseType = null;
    }
}

